package com.bokesoft.yigo.meta.form.component.panel;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaHandleEnum;

public class MetaSplitSize extends AbstractMetaObject {
	/** 拆分大小 */
	private DefSize size = null;
	Integer type = MetaSplitSizeCollapaseTypeEnum.All.getType();
	Boolean ForwardCollapased = false;
	Boolean ReverseCollapased = false;
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}

	public Boolean getForwardCollapased() {
		return ForwardCollapased;
	}

	public void setForwardCollapased(Boolean forwardCollapased) {
		ForwardCollapased = forwardCollapased;
	}

	public Boolean getReverseCollapased() {
		return ReverseCollapased;
	}

	public void setReverseCollapased(Boolean reverseCollapased) {
		ReverseCollapased = reverseCollapased;
	}

	public static final String TAG_NAME = "SplitSize";

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
													Object node, String tagName, Object flag, int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	/**
	 * 设置拆分区域大小，取值只能是比例和固定值
	 * @param size 大小
	 * @see DefSize
	 */
	public void setSize(DefSize size) {
		this.size = size;
	}

	/**
	 * 取得拆分区域大小
	 * @return 大小
	 * @see DefSize
	 */
	public DefSize getSize() {
		return this.size;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaSplitSize newObject = new MetaSplitSize();
		if (size != null) {
			DefSize newSize = DefSize.parse(size.toString());
			newObject.setSize(newSize);
		} else {
			newObject.setSize(null);
		}
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaSplitSize();
	}
}
