package com.bokesoft.yigo.meta.form.component.grid;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.struct.report.MultiDimValue;
import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.common.def.RowType;
import com.bokesoft.yigo.common.def.SubDetailLinkType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollectionWithKey;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.IPropertyMerger;
import com.bokesoft.yigo.meta.form.MetaUICheckRuleCollection;

/**
 * MetaGridRow定义表格中的一行的描述信息，包括行的标识、行的类型(取值范围可见{@link com.bokesoft.yigo.common.def.RowType})、
 * 行高、绑定的表信息，同时行对象包括组成行的每个单元格的描述信息，一个行由多个单元格组成，见{@link MetaGridCell}}
 * @author 王元和
 * @see MetaGridCell
 */
public class MetaGridRow extends GenericNoKeyCollectionWithKey<MetaGridCell> implements IMetaGridRowObject, IDimValueAware, IPropertyMerger<MetaGridRow> {
	/** 行的标识 */
	private String key = "";
	/** 行的类型标识,取值范围见{@link com.bokesoft.yigo.common.def.RowType}*/
	private Integer rowType = RowType.Detail;
	/** 默认行高*/
	public static final int DEFAULT_HEIGHT = 32;
	/** 行高 */
	private Integer rowHeight = DEFAULT_HEIGHT;
	/** 表的标识 */
	private String tableKey = "";
	/**所属分组的标识,只对分组行有效*/
	private String groupKey = "";
	/**默认的层级，用于判定表是否进行层次数据显示，为-1时，表示显示所有数据，不进行层次过滤,-2表示未定义*/
	private Integer defaultLayer = -1;
	/** 行检查规则集合 */
	private MetaUICheckRuleCollection checkRuleCollection = null;
	/** 可见性,针对非明细行*/
	private String visible = "";
	/** 冻结,针对非明细行*/
	private Boolean frozen = false;

	/** 子明细的关联方式,-1表示未定义*/
	private Integer linkType = SubDetailLinkType.PARENT;
	/** 子明细外键关联方式的源字段*/
	private String source = "";
	private List<String> sourceFields = new ArrayList<String>();
	/** 设置子明细外键关联方式的目标表字段*/
	private String target = "";
	private List<String> targetFields = new ArrayList<String>();

	/** 明细行属性,用以表示引用的主明细行数据*/
	private String refKey = "";

	/** 填报报表使用的关键词(维度)定义,定义在明细行,预处理转成dimValue*/
	private String keywords = "";
	/** 维度数据,用于填报报表*/
	private MultiDimValue dimValue = null;

	/** 拓展区域*/
	private Integer areaIndex = -1;
	/** 是否是区域拓展的行*/
	private Boolean areaExpand = false;

	/** 行拓展*/
	private MetaRowExpand rowExpand = null;
	/** 行树形*/
	private MetaRowTree rowTree = null;

	/** 所属区域的明细标识*/
	private String detailKey = "";

	//---------------------------非配置属性------------------------------------

	/** 是否分组头(分组行有效)*/
	private boolean isGroupHead = false;
	/** 是否分组尾(分组行有效)*/
	private boolean isGroupTail = false;

	//-------------------多明细---------------
	/** 是否明细头(固定行有效)*/
	private boolean isDetailHead = false;
	/** 区域明细行号*/
	private int detailIndex = -1;
	/** 是否明细尾(固定行有效)*/
	private boolean isDetailTail = false;

	//-------------------多区域--------------
	/** 是否区域头(固定行有效)*/
	private boolean isAreaHead = false;
	/** 是否区域尾(固定行有效)*/
	private boolean isAreaTail = false;

	//----------------------style-------------------
	/** 背景色*/
	private String backColor = "";

	//--------------程序启动时,分配的回收模式---------------
	private int recycleMode = -1;
	private String rowTreeImg = "";

	/**
	 * 设置表格树时行显示图片
	 * @param rowTreeImg 默认层级
	 */
	public void setRowTreeImg(String rowTreeImg){
		this.rowTreeImg = rowTreeImg;
	}

	/**
	 * 设置表格树时行显示图片
	 * @return 设置表格树时行显示图片
	 */
	public String getRowTreeImg(){
		return rowTreeImg;
	}
	/**
	 * 设置行数据需要显示的默认层级
	 * @param layer 默认层级
	 */
	public void setDefaultLayer(Integer layer){
		defaultLayer = layer;
	}

	/**
	 * 获取行数据需要显示的默认层级
	 * @return 行数据需要显示的默认层级
	 */
	public Integer getDefaultLayer(){
		return defaultLayer;
	}

	/**
	 * 获取回收模式
	 * @return 回收模式
	 */
	public Integer getRecycleMode() {
		return recycleMode;
	}

	/**
	 * 设置回收模式
	 * @param recycleMode 回收模式
	 */
	public void setRecycleMode(int recycleMode) {
		this.recycleMode = recycleMode;
	}

	/**
	 * 获取引用的行标识
	 * @return 引用的行标识
	 */
	public String getRefKey() {
		return refKey;
	}

	/**
	 * 设置引用的行标识
	 * @param refKey 引用的行标识
	 */
	public void setRefKey(String refKey) {
		this.refKey = refKey;
	}

	public Boolean isAreaExpand() {
		return areaExpand;
	}

	public void setAreaExpand(Boolean areaExpand) {
		this.areaExpand = areaExpand;
	}

	/**
	 * 获取行树形定义
	 * @return 树形定义
	 */
	public MetaRowTree getRowTree() {
		return rowTree;
	}

	/**
	 * 设置行树形定义
	 * @param rowTree 树形定义
	 */
	public void setRowTree(MetaRowTree rowTree) {
		this.rowTree = rowTree;
	}

	/**
	 * 返回树形定义，如果为null则新建一个树形定义并返回
	 * @return 树形定义
	 */
	public MetaRowTree ensureTree() {
		if( rowTree == null ) {
			rowTree = new MetaRowTree();
		}
		return rowTree;
	}

	/**
	 * 取得行扩展定义
	 * @return 行扩展定义
	 */
	public MetaRowExpand getRowExpand() {
		return rowExpand;
	}

	/**
	 * 设置行扩展定义
	 * @param gridRowExpand 行扩展定义
	 */
	public void setRowExpand(MetaRowExpand gridRowExpand) {
		this.rowExpand = gridRowExpand;
	}

	/**
	 * 获取区域编号
	 * @return
	 */
	public Integer getAreaIndex() {
		return areaIndex;
	}

	/**
	 * 设置区域编号
	 * @param areaIndex
	 */
	public void setAreaIndex(Integer areaIndex) {
		this.areaIndex = areaIndex;
	}

	/**
	 * 返回行扩展定义，如果为null则新建一个行扩展定义并返回
	 * @return 行扩展定义
	 */
	public MetaRowExpand ensureRowExpand() {
		if( rowExpand == null ) {
			rowExpand = new MetaRowExpand();
		}
		return rowExpand;
	}

	/**
	 * 是否冻结
	 * @return 是否冻结
	 */
	public Boolean isFrozen() {
		return frozen == null ? false : frozen;
	}

	/**
	 * 设置是否冻结
	 * @param frozen 是否冻结
	 */
	public void setFrozen(Boolean frozen) {
		this.frozen = frozen;
	}

	/**
	 * 获取可见性定义
	 * @return 可见性定义
	 */
	public String getVisible() {
		return visible;
	}

	/**
	 * 设置可见性定义
	 * @param visible
	 */
	public void setVisible(String visible) {
		this.visible = visible;
	}

	/**
	 * 获取关键字
	 * @return 关键字
	 */
	public String getKeywords() {
		return keywords;
	}

	/**
	 * 设置关键字
	 * @param keywords 关键字
	 */
	public void setKeywords(String keywords) {
		this.keywords = keywords;
	}

	/**
	 * 设置行维度数据
	 * @param dimValue 维度数据
	 */
	public void setDimValue(MultiDimValue dimValue) {
		this.dimValue = dimValue;
	}

	/**
	 * 获取行维度数据
	 * @return 维度数据
	 */
	public MultiDimValue getDimValue() {
		return dimValue;
	}

	/**
	 * 获得分组的标识
	 * @return groupKey 分组标识
	 */
	public String getGroupKey() {
		return groupKey;
	}

	/**
	 * 设置分组的标识
	 * @param groupKey 组标识
	 */
	public void setGroupKey(String groupKey) {
		this.groupKey = groupKey;
	}

	/**
	 * 获取所属区域明细标识
	 * @return
	 */
	public String getDetailKey() {
		return detailKey;
	}

	/**
	 * 设置所属区域明细标识
	 * @param detailKey
	 */
	public void setDetailKey(String detailKey) {
		this.detailKey = detailKey;
	}

	/**
	 * 获取背景颜色
	 * @return 背景色
	 */
	public String getBackColor() {
		return backColor;
	}

	/**
	 * 设置背景颜色
	 * @param backColor 背景色
	 */
	public void setBackColor(String backColor) {
		this.backColor = backColor;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		if( checkRuleCollection != null ) {
			list.add(checkRuleCollection);
		}
		if ( rowExpand != null ) {
			list.add(this.rowExpand);
		}
		if( rowTree != null ) {
			list.add(this.rowTree);
		}
	}

	public static final String TAG_NAME = "GridRow";

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node,
													String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject metaObject = null;
		if ( MetaGridCell.TAG_NAME.equals(tagName) ) {
			MetaGridCell metaGridCell = new MetaGridCell();
			metaGridCell.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(metaGridCell);
			metaObject = metaGridCell;
		} else if ( MetaUICheckRuleCollection.TAG_NAME.equals(tagName) ) {
			this.checkRuleCollection = new MetaUICheckRuleCollection();
			metaObject = this.checkRuleCollection;
		} else if ( MetaRowExpand.TAG_NAME.equals(tagName) ) {
			rowExpand = new MetaRowExpand();
			metaObject = rowExpand;
		} else if ( MetaRowTree.TAG_NAME.equals(tagName) ) {
			rowTree = new MetaRowTree();
			metaObject = rowTree;
		}
		return metaObject;
	}

	/**
	 * 设置行标识
	 * @param key 标识
	 */
	public void setKey(String key) {
		this.key = key;
	}

	/**
	 * 取得行标识
	 * @return 标识
	 */
	public String getKey() {
		return this.key;
	}

	/**
	 * 设置行类型标识
	 * @param rowType 行类型取值，取值见{@link com.bokesoft.yigo.common.def.RowType}
	 * @see com.bokesoft.yigo.common.def.RowType
	 */
	public void setRowType(Integer rowType) {
		this.rowType = rowType;
	}

	/**
	 * 取得行类型标识
	 * @return 行类型标识
	 */
	public Integer getRowType() {
		return this.rowType;
	}

	/**
	 * 获取子明细的关联方式
	 * @return 子明细的关联方式
	 */
	public Integer getLinkType() {
		return linkType;
	}

	/**
	 * 设值子明细的关联方式
	 * @param linkType 子明细的关联方式
	 */
	public void setLinkType(Integer linkType) {
		this.linkType = linkType;
	}

	/**
	 * 设置行高
	 * @param rowHeight 高度
	 */
	public void setRowHeight(Integer rowHeight) {
		this.rowHeight = rowHeight;
	}

	/**
	 * 取得行高
	 * @return 高度
	 */
	public Integer getRowHeight() {
		return this.rowHeight;
	}

	/**
	 * 设置表的标识
	 * @param tableKey 标识
	 */
	public void setTableKey(String tableKey) {
		this.tableKey = tableKey;
	}

	/**
	 * 取得表的标识
	 * @return 标识
	 */
	public String getTableKey() {
		return this.tableKey;
	}

	@Override
	public int getObjectType() {
		return IMetaGridRowObject.Row;
	}

	/**
	 * 获取子明细外键关联的源表字段
	 * @return 子明细外键关联的源表字段
	 */
	public String getSource() {
		return source;
	}

	/**
	 * 设置子明细外键关联的源表字段
	 * @param source 子明细外键关联的源表字段
	 */
	public void setSource(String source) {
		this.source = source;
		this.sourceFields.clear();
		if( source != null && !source.isEmpty() ) {
			String[] sources = source.split(",");
			for(int i=0;i<sources.length;i++){
				sourceFields.add(sources[i]);
			}
		}
	}

	/**
	 * 获取子明细外键关联的目标表字段
	 * @return 目标
	 */
	public String getTarget() {
		return target;
	}

	/**
	 * 设置子明细外检关联的目标表字段
	 * @param target 目标字段标识
	 */
	public void setTarget(String target) {
		this.target = target;
		this.targetFields.clear();
		if(target != null && !target.isEmpty()) {
			String[] targets = target.split(",");
			for(int i=0;i<targets.length;i++){
				targetFields.add(targets[i]);
			}
		}
	}


	public List<String> getSourceFields() {
		return sourceFields;
	}

	public List<String> getTargetFields() {
		return targetFields;
	}

	public void setSourceFields(List<String> sourceFields) {
		this.sourceFields = sourceFields;
	}

	public void setTargetFields(List<String> targetFields) {
		this.targetFields = targetFields;
	}

	/**
	 * 设置行检查规则集合
	 * @param checkRuleCollection 检查规则集合
	 */
	public void setCheckRuleCollection(MetaUICheckRuleCollection checkRuleCollection) {
		this.checkRuleCollection = checkRuleCollection;
	}

	/**
	 * 取得行检查规则集合
	 * @return 检查规则集合
	 */
	public MetaUICheckRuleCollection getCheckRuleCollection() {
		return this.checkRuleCollection;
	}

	@Override
	public void printDebugInfo(int level) {
		Iterator<MetaGridCell> it = this.iterator();
		MetaGridCell metaGridCell = null;
		StringBuilder sb = new StringBuilder();
		while ( it.hasNext() ) {
			metaGridCell = it.next();
			sb.append(metaGridCell.getKey());
			sb.append('\t');
			sb.append('\t');
		}
		LogSvr.getInstance().info("row" + "\t" + level + "\t\t" + sb.toString());
	}

	@Override
	public AbstractMetaObject clone() {
		MetaGridRow newObject = (MetaGridRow)super.clone();
		newObject.setKey(key);
		newObject.setRowType(rowType);
		newObject.setRowHeight(rowHeight);
		newObject.setTableKey(tableKey);
		newObject.setGroupKey(groupKey);
		newObject.setDetailKey(detailKey);
		newObject.setDefaultLayer(defaultLayer);
		newObject.setGroupHead(isGroupHead);
		newObject.setGroupTail(isGroupTail);
		newObject.setAreaHead(isAreaHead);
		newObject.setDetailIndex(detailIndex);
		newObject.setAreaTail(isAreaTail);
		newObject.setLinkType(linkType);
		newObject.setSource(source);
		newObject.setTarget(target);
		newObject.setVisible(visible);
		newObject.setBackColor(backColor);
		newObject.setFrozen(frozen);
		newObject.setKeywords(keywords);
		newObject.setRecycleMode(recycleMode);
		newObject.setRowTree(rowTree == null ? null : (MetaRowTree)rowTree.clone());
		newObject.setRowExpand(rowExpand == null ? null : (MetaRowExpand)rowExpand.clone());
		newObject.setCheckRuleCollection(checkRuleCollection == null ? null : (MetaUICheckRuleCollection)checkRuleCollection.clone());
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaGridRow();
	}

	@Override
	public void getAll(int objectType, ArrayList<IMetaGridRowObject> list) {
		// TODO Auto-generated method stub

	}

	public void setGroupHead(boolean b) {
		isGroupHead = b;
	}
	public boolean isGroupHead(){
		return isGroupHead;
	}
	public void setGroupTail(boolean b) {
		isGroupTail = b;
	}
	public boolean isGroupTail(){
		return isGroupTail;
	}

	public boolean isAreaHead() {
		return isAreaHead;
	}

	public void setAreaHead(boolean isAreaHead) {
		this.isAreaHead = isAreaHead;
	}

	public int getDetailIndex() {
		return detailIndex;
	}

	public void setDetailIndex(int detailIndex) {
		this.detailIndex = detailIndex;
	}

	public boolean isAreaTail() {
		return isAreaTail;
	}

	public void setAreaTail(boolean isAreaTail) {
		this.isAreaTail = isAreaTail;
	}

	public boolean isDetailHead() {
		return isDetailHead;
	}

	public void setDetailHead(boolean isDetailHead) {
		this.isDetailHead = isDetailHead;
	}

	public boolean isDetailTail() {
		return isDetailTail;
	}

	public void setDetailTail(boolean isDetailTail) {
		this.isDetailTail = isDetailTail;
	}

	public boolean isFix(){
		return rowType == RowType.Fix;
	}

	public boolean isDetail(){
		return rowType == RowType.Detail;
	}

	@Override
	public int getObjectCount() {
		return 0;
	}

	@Override
	public IMetaGridRowObject getObject(int index) {
		// TODO Auto-generated method stub
		return null;
	}

	public boolean hasDataBinding() {
		return this.tableKey != null && !this.tableKey.isEmpty();
	}

	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
		super.doPostProcess(flag, callback);
		if( this.rowExpand != null ) {
			this.rowExpand.doPostProcess(flag, callback);
		}
		if( this.rowTree != null ) {
			this.rowTree.doPostProcess(flag, callback);
		}
	}

	public MetaGridCell findCellByKey(String cellKey){
		for( MetaGridCell metaCell : this ) {
			if( metaCell.getKey().equals(cellKey) ) {
				return metaCell;
			}
		}
		return null;
	}

	@Override
	public void merge(MetaGridRow metaRow) {
		if( this.rowType == -1 ) {
			this.rowType = metaRow.getRowType();
		}
		if( this.tableKey == null ) {
			this.tableKey = metaRow.getTableKey();
		}
		if( this.groupKey == null ) {
			this.groupKey = metaRow.getGroupKey();
		}
		if( this.detailKey == null ) {
			this.detailKey = metaRow.getDetailKey();
		}
		// 高度不定义取默认值
//		if( this.rowHeight == -1 ) {
//			this.rowHeight = metaRow.getRowHeight();
//		}
		if( this.defaultLayer == null ) {
			this.defaultLayer = metaRow.getDefaultLayer();
		}
		if( this.checkRuleCollection == null ) {
			MetaUICheckRuleCollection crc = metaRow.getCheckRuleCollection();
			if( crc != null ) {
				this.checkRuleCollection = (MetaUICheckRuleCollection) crc.clone();
			}
		}
		if( this.visible == null ) {
			this.visible = metaRow.getVisible();
		}
		if( this.linkType == -1 ) {
			this.linkType = metaRow.getLinkType();
		}
		if( this.source == null ) {
			this.source = metaRow.getSource();
		}
		if( this.target == null ) {
			this.target = metaRow.getTarget();
		}
		if( this.backColor == null ) {
			this.backColor = metaRow.getBackColor();
		}
		if( this.frozen == null ) {
			this.frozen = metaRow.isFrozen();
		}
		if (this.rowExpand == null) {
            MetaRowExpand rowExpand = metaRow.getRowExpand();
            if( rowExpand != null ) {
                this.rowExpand = (MetaRowExpand) rowExpand.depthClone();
            }
        }
        if (this.rowTree == null) {
            MetaRowTree rowTree = metaRow.getRowTree();
            if( rowTree != null ) {
                this.rowTree = (MetaRowTree) rowTree.depthClone();
			}
		}
	}

	@Override
	public boolean needPreLoad() {
		return false;
	}
}
