package com.bokesoft.yigo.meta.form.component.control.refresh;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.MetaFormat;

public class MetaRefreshState extends AbstractMetaObject {
	
	public static final String TAG_NAME = "State";
	
	/**
	 * 文本和背景样式
	 */
	private MetaFormat format = null;
	
	/**
	 * 文本
	 */
	private String text;
	
	/**
	 * 图标
	 */
	private String icon;
	
	/**
	 * 图标位置
	 */
	private Integer iconLocation;
	
	/**
	 * 类型
	 */
	private Integer type;
	
	/**
	 * 获取文本和背景样式
	 * @return 文本和背景样式
	 */
	public MetaFormat getFormat() {
		return format;
	}

	/**
	 * 设置文本和背景样式
	 * @param format 文本和背景样式
	 */
	public void setFormat(MetaFormat format) {
		this.format = format;
	}
	
	/**
	 * 获取文本
	 * @return 文本
	 */
	public String getText() {
		return text;
	}
	
	/**
	 * 设置文本
	 * @param text 文本
	 */
	public void setText(String text) {
		this.text = text;
	}

	/**
	 * 获取图标
	 * @return 图标
	 */
	public String getIcon() {
		return icon;
	}

	/**
	 * 设置图标
	 * @param icon 图标
	 */
	public void setIcon(String icon) {
		this.icon = icon;
	}

	/**
	 * 获取图标位置
	 * @return 图标位置
	 */
	public Integer getIconLocation() {
		return iconLocation;
	}

	/**
	 * 设置图标位置
	 * @param iconLocation 图标位置
	 */
	public void setIconLocation(Integer iconLocation) {
		this.iconLocation = iconLocation;
	}
	
	/**
	 * 获取类型
	 * @return 类型
	 */
	public Integer getType() {
		return type;
	}
	
	/**
	 * 设置类型
	 * @param type 类型
	 */
	public void setType(Integer type) {
		this.type = type;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new AbstractMetaObject[] { format});
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (MetaFormat.TAG_NAME.equals(tagName)) {
			format = new MetaFormat();
			resultMetaObject = format;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaRefreshState newObj = (MetaRefreshState)this.newInstance();
		newObj.setFormat(format == null ? null : (MetaFormat)format.clone());
		newObj.setIcon(icon);
		newObj.setIconLocation(iconLocation);
		newObj.setText(text);
		newObj.setType(type);
		return newObj;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaRefreshState();
	}

}
