package com.bokesoft.yigo.meta.form.component.control.refresh;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.MetaFormat;

public class MetaRefreshHeader extends MetaBaseScript {

	public static final String TAG_NAME = "RefreshHeader";

	/**
	 * 文本和背景样式
	 */
	private MetaFormat format = null;
	
	/**
	 * 文本
	 */
	private String text;
	
	/**
	 * 图标
	 */
	private String icon;
	
	/**
	 * 图标位置
	 */
	private Integer iconLocation;
	
	/**
	 * 状态样式集合
	 */
	private MetaRefreshStateCollection stateCollection;
	
	
	public MetaRefreshHeader(){
		super(TAG_NAME);
		stateCollection = new MetaRefreshStateCollection();
	}

	/**
	 * 获取文本和背景样式
	 * @return 文本和背景样式
	 */
	public MetaFormat getFormat() {
		return format;
	}

	/**
	 * 设置文本和背景样式
	 * @param format 文本和背景样式
	 */
	public void setFormat(MetaFormat format) {
		this.format = format;
	}
	
	/**
	 * 获取文本
	 * @return 文本
	 */
	public String getText() {
		return text;
	}
	
	/**
	 * 设置文本
	 * @param text 文本
	 */
	public void setText(String text) {
		this.text = text;
	}

	/**
	 * 获取图标
	 * @return 图标
	 */
	public String getIcon() {
		return icon;
	}

	/**
	 * 设置图标
	 * @param icon 图标
	 */
	public void setIcon(String icon) {
		this.icon = icon;
	}

	/**
	 * 获取图标位置
	 * @return 图标位置
	 */
	public Integer getIconLocation() {
		return iconLocation;
	}

	/**
	 * 设置图标位置
	 * @param iconLocation 图标位置
	 */
	public void setIconLocation(Integer iconLocation) {
		this.iconLocation = iconLocation;
	}

	/**
	 * 获取状态样式集合
	 * @return 状态样式集合
	 */
	public MetaRefreshStateCollection getStateCollection() {
		return stateCollection;
	}
	
	/**
	 * 设置状态样式集合
	 * @param iconLocation 状态样式集合
	 */
	public void setStateCollection(MetaRefreshStateCollection stateCollection) {
		this.stateCollection = stateCollection;
	}

	/**
	 * 获取文本和背景样式，保证不为空
	 * @return 文本和背景样式
	 */
	public MetaFormat ensureFormat() {
		if( format == null ) {
			format = new MetaFormat();
		}
		return this.format;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new AbstractMetaObject[] { format,stateCollection});
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = stateCollection.createChildMetaObject(env, doc, node, tagName, flag, runType);
		if (resultMetaObject == null) {
			if (MetaFormat.TAG_NAME.equals(tagName)) {
				format = new MetaFormat();
				resultMetaObject = format;
			}
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaRefreshHeader newObj = (MetaRefreshHeader)super.clone();
		newObj.setFormat(format == null ? null : (MetaFormat)format.clone());
		newObj.setStateCollection(stateCollection == null ? null : (MetaRefreshStateCollection)stateCollection.clone());
		newObj.setIcon(icon);
		newObj.setIconLocation(iconLocation);
		newObj.setText(text);
		return newObj;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaRefreshHeader();
	}

}
