package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ComboBoxSourceType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.control.MetaDefaultItem;

public class MetaSegmentedControlProperties extends AbstractMetaObject {
	/** 是否可编辑 */
	private Boolean isEditable = false;
	
	/** 是否是动态的下拉项集合 */
	private Boolean isDynamicItems = false;
	
	/** 表达式表示的下拉项集合 */
	private MetaBaseScript formulaItems = null;

	/** 固定下拉项集合*/
	private MetaListBoxItemCollection items = null;
	
	/** 下拉项的依赖*/
	private String itemsDependency = "";

	/** 下拉所依赖的字段*/
	private List<String> dependentFields = new ArrayList<String>();
	
	/** 查询来源的查询定义*/
	private MetaQueryDef query = null;
	
	/** 下拉项来源*/
	private Integer sourceType = ComboBoxSourceType.ITEMS;
	
	/** 当sourceType为ParaGroup时 的分组标志*/
	private String groupKey = "";
	
	/** 全局下拉定义*/
	private String globalItems = "";
	
	/** 该属性用于确定在GetValue时是否返回整型值,方便进行运算,默认值是字符串*/
	private Boolean integerValue = false;
			
	public MetaSegmentedControlProperties() {
		super();
		items = new MetaListBoxItemCollection();
	}
	
	/**
	 * 设置是否可编辑
	 * 
	 * @param isEditable
	 *            是否可编辑
	 */
	public void setEditable(Boolean isEditable) {
		this.isEditable = isEditable;
	}

	/**
	 * 获取是否可编辑
	 * 
	 * @return 是否可编辑
	 */
	public Boolean isEditable() {
		return this.isEditable;
	}
	
	/**
	 * 获取全局下拉项定义
	 * @return 全局下拉项定义
	 */
	public String getGlobalItems() {
		return globalItems;
	}

	/**
	 * 设置全局下拉项定义
	 * @param globalItems 全局下拉项定义
	 */
	public void setGlobalItems(String globalItems) {
		this.globalItems = globalItems;
	}

	/**
	 * 设置是否动态下拉项
	 * @param isDynamicItems 动态下拉项标志
	 */
	public void setDynamicItems(Boolean isDynamicItems) {
		this.isDynamicItems = isDynamicItems;
	}
	
	/**
	 * 取得是否动态下拉项
	 * @return 动态下拉项标志
	 */
	public Boolean isDynamicItems() {
		return this.isDynamicItems;
	}
	
	/**
	 * 设置表达式下拉项
	 * @param formulaItems 脚本元数据
	 */
	public void setFormulaItems(MetaBaseScript formulaItems) {
		this.formulaItems = formulaItems;
	}
	
	/**
	 * 取得表达式下拉项
	 * @return 脚本元数据
	 */
	public MetaBaseScript getFormulaItems() {
		return this.formulaItems;
	}
	
	/**
	 * 载入的时候会将类型为Field的查询参数加入进来,
	 * 所以可以直接获取
	 * 
	 * @return 下拉项依赖的字段集合
	 */
	public List<String> getDependedFields(){
		return this.dependentFields;
	}
	
	/**
	 * 获取依赖
	 * @return 依赖
	 */
	public String getItemsDependency(){
		return this.itemsDependency;
	}
	
	/**
	 * 设置依赖
	 * @param dependency 依赖
	 */
	public void setItemsDependency(String dependency){
		this.itemsDependency = "";
		this.dependentFields.clear();
		if(dependency != null && dependency.length() > 0){
			this.itemsDependency = dependency;
	
			String[] fields = this.itemsDependency.split(",");
			
			for(String field : fields){
				dependentFields.add(field);
			}
		}
	}

	/**
	 * 设置依赖列表
	 * @param dependentFields 依赖列表
	 */
	public void setDependentFields(List<String> dependentFields) {
		this.dependentFields = dependentFields;
	}

	/**
	 * 取得是否取整型值
	 * @return 是否取整型标志
	 */
	public Boolean isIntegerValue() {
		return integerValue;
	}

	/**
	 * 设置是否取整型值
	 * @param integerValue 是否取整型标志
	 */
	public void setIntegerValue(Boolean integerValue) {
		this.integerValue = integerValue;
	}

	/**
	 * 获取下拉项的总数
	 * 
	 * @return 下拉项总数
	 */
	public int getItemCount() {
		return items.size();
	}

	/**
	 * 根据序号获取下拉项
	 * 
	 * @param index
	 *            序号
	 * @return 下拉项
	 */
	public MetaDefaultItem getItem(int index) {
		return items.get(index);
	}

	/**
	 * 设置下拉项集合
	 * @param items 下拉项集合
	 */
	public void setItems(MetaListBoxItemCollection items) {
		this.items = items;
	}
	
	/**
	 * 取得下拉项集合
	 * @return 下拉项集合
	 */
	public MetaListBoxItemCollection getItems() {
		return items;
	}
	
	/**
	 * 设置查询定义
	 * @param query 查询定义
	 */
	public void setQueryDef(MetaQueryDef query) {
		this.query = query;
	}
	
	/**
	 * 取得查询定义
	 * @return 查询定义
	 */
	public MetaQueryDef getQueryDef(){
		return this.query;
	}
	
	/**
	 * 取得来源类型
	 * @return 来源类型
	 */
	public Integer getSourceType(){
		return this.sourceType;
	}
	
	/**
	 * 取得来源类型
	 * @param type 来源类型
	 */
	public void setSourceType(Integer type){
		this.sourceType = type;
	}
	
	public String getGroupKey() {
		return groupKey;
	}

	public void setGroupKey(String groupKey) {
		this.groupKey = groupKey;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new AbstractMetaObject[] { items, formulaItems,query });
	}

	@Override
	public String getTagName() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject,Boolean> callback) throws MetaException {
		super.doPostProcess(flag, callback);
		if(this.query != null){
			query.doPostProcess(flag, callback);
			
			List<String> list = this.query.getDependedFields();
			if(list != null){
				for(String field : list){
					if(!this.dependentFields.contains(field)){
						this.dependentFields.add(field);
					}
				}
			}
		}
	}
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = items.createChildMetaObject(env, doc, node, tagName, flag, runType);
		if ( resultMetaObject == null ) {
			if ( tagName.equalsIgnoreCase(MetaConstants.COMBOBOX_FORMULAITEMS) ) {
				this.formulaItems = new MetaBaseScript(MetaConstants.COMBOBOX_FORMULAITEMS);
				resultMetaObject = formulaItems;
			}else if(tagName.equalsIgnoreCase(MetaQueryDef.TAG_NAME)){
				this.query = new MetaQueryDef();
				resultMetaObject = query;
			}
		}

		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaSegmentedControlProperties newObject = new MetaSegmentedControlProperties();
		newObject.setEditable(isEditable);
		newObject.setItems(items == null ? null : (MetaListBoxItemCollection)items.clone());
		newObject.setDynamicItems(isDynamicItems);
		newObject.setFormulaItems(formulaItems == null ? null : (MetaBaseScript)formulaItems.clone());
		newObject.setItemsDependency(itemsDependency);
		newObject.setQueryDef(query == null ? null : (MetaQueryDef)query.clone());
		newObject.setSourceType(this.sourceType);
		newObject.setGroupKey(groupKey);
		newObject.setGlobalItems(globalItems);
		newObject.setIntegerValue(integerValue);
		newObject.setDependentFields(dependentFields);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaSegmentedControlProperties();
	}
}
