package com.bokesoft.yigo.meta.form.component.control.properties;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.IconLocationType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.IPropertyMerger;
import com.bokesoft.yigo.meta.form.component.control.MetaTextEditor;

import java.util.LinkedList;

public class MetaRadioButtonProperties extends AbstractMetaObject implements IPropertyMerger<MetaRadioButtonProperties> {

	/** 单选框所属组的标识 */
	private String groupKey = "";
	/** 是否为组的主控件 */
	private Boolean isGroupHead = false;
	/** 选中时的取值 */
	private String selectedValue = "";
	/**默认图标*/
	private String icon = "";
	/**选中图标*/
	private String selectedIcon = "";
	/**图标位置*/
	private Integer iconLocation = IconLocationType.LEFT;
	/**是否隐藏图标按钮*/
	private Boolean isHideButton = false;

	public String getGroupKey() {
		return groupKey;
	}

	public void setGroupKey(String groupKey) {
		this.groupKey = groupKey;
	}

	public Boolean getGroupHead() {
		return isGroupHead;
	}

	public void setGroupHead(Boolean groupHead) {
		isGroupHead = groupHead;
	}

	public String getSelectedValue() {
		return selectedValue;
	}

	public void setSelectedValue(String selectedValue) {
		this.selectedValue = selectedValue;
	}

	public String getIcon() {
		return icon;
	}

	public void setIcon(String icon) {
		this.icon = icon;
	}

	public String getSelectedIcon() {
		return selectedIcon;
	}

	public void setSelectedIcon(String selectedIcon) {
		this.selectedIcon = selectedIcon;
	}

	public Integer getIconLocation() {
		return iconLocation;
	}

	public void setIconLocation(Integer iconLocation) {
		this.iconLocation = iconLocation;
	}

	public Boolean getHideButton() {
		return isHideButton;
	}

	public void setHideButton(Boolean hideButton) {
		isHideButton = hideButton;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
	}

	@Override
	public String getTagName() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaRadioButtonProperties newObject = (MetaRadioButtonProperties) newInstance();
		newObject.setGroupHead(this.isGroupHead);
		newObject.setHideButton(this.isHideButton);
		newObject.setGroupKey(this.groupKey);
		newObject.setIcon(this.icon);
		newObject.setIconLocation(this.iconLocation);
		newObject.setSelectedIcon(this.selectedIcon);
		newObject.setSelectedValue(this.selectedValue);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaRadioButtonProperties();
	}

	@Override
	public void merge(MetaRadioButtonProperties properties) {
		if( this.isGroupHead == null ) {
			this.isGroupHead = properties.getGroupHead();
		}
		if( this.isHideButton == null ) {
			this.isHideButton = properties.getHideButton();
		}
		if( this.groupKey == null ) {
			this.groupKey = properties.getGroupKey();
		}
		if( this.icon == null ) {
			this.icon = properties.getIcon();
		}
		if( this.iconLocation == null ) {
			this.iconLocation = properties.getIconLocation();
		}
		if( this.selectedIcon == null ) {
			this.selectedIcon = properties.getSelectedIcon();
		}
		if( this.selectedValue == null ) {
			this.selectedValue = properties.getSelectedValue();
		}
	}
}
