package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaProgressBarItem extends AbstractMetaObject{
	
	public static final String TAG_NAME = "ProgressBarItem"; 
	
	/** 开始节点 */
	private Integer startPos = 0;
	
	/** 结束节点 */
	private Integer endPos = 0;
	
	/** 颜色 */
	private String color;
	
	
	/**
	 * 获取开始节点
	 * @return 开始节点
	 */
	public Integer getStartPos() {
		return startPos;
	}

	/**
	 * 设置开始节点
	 * @param startPos 开始节点
	 */
	public void setStartPos(Integer startPos) {
		this.startPos = startPos;
	}

	/**
	 * 获取结束节点
	 * @return 结束节点
	 */
	public Integer getEndPos() {
		return endPos;
	}

	/**
	 * 设置结束节点
	 * @param endPos 结束节点
	 */
	public void setEndPos(Integer endPos) {
		this.endPos = endPos;
	}

	/**
	 * 获取颜色
	 * @return 颜色
	 */
	public String getColor() {
		return color;
	}
	
	/**
	 * 设置颜色
	 * @param progressColor 颜色
	 */
	public void setColor(String color) {
		this.color = color;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaProgressBarItem item = (MetaProgressBarItem)newInstance();
		item.setEndPos(endPos);
		item.setStartPos(startPos);
		item.setColor(color);
		return item;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaProgressBarItem();
	}

}
