package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.MetaFormat;

public class MetaPriceLabelItem extends AbstractMetaObject {
	
	public static final String TAG_NAME = "PriceItem";

	/**
	 * 类型，Item中用来定义需要进行处理样式的片段， 
	 * 值为：PreText（前置文本）、Integer（整数部分）和Decimal（小数部分）
	 */
	private Integer type = -1;
	
	/** 格式化对象*/
	private MetaFormat format = null;

	/**
	 * 获取类型
	 * @return 类型，Item中用来定义需要进行处理样式的片段， 
	 * 值为：PreText（前置文本）、Integer（整数部分）和Decimal（小数部分）
	 */
	public Integer getType() {
		return type;
	}
	
	/**
	 * 设置类型
	 * @param type 类型，Item中用来定义需要进行处理样式的片段， 
	 * 值为：PreText（前置文本）、Integer（整数部分）和Decimal（小数部分）
	 */
	public void setType(Integer type) {
		this.type = type;
	}
	
	/**
	 * 获取格式化对象
	 * @return 格式化对象
	 */
	public MetaFormat getFormat() {
		return format;
	}
	
	/**
	 * 设置格式化对象
	 * @param format 格式化对象
	 */
	public void setFormat(MetaFormat format) {
		this.format = format;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		list.add(format);
	}
	
	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
		if ( format != null ) {
			format.doPostProcess(flag, callback);
		}
	}
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (tagName.equals(MetaFormat.TAG_NAME)) {
			format = new MetaFormat();
			resultMetaObject = format;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaPriceLabelItem newObject = (MetaPriceLabelItem) newInstance();
		newObject.setType(type);
		newObject.setFormat(format == null ? null : (MetaFormat)format.clone());
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaPriceLabelItem();
	}

}
