package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.LinkedList;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.control.MetaImageListItem;

public class MetaImageListProperties extends GenericKeyCollection<MetaImageListItem> {

	/** 点击事件 */
	private MetaBaseScript onClick = null;
//	/** 是否拉伸 */
//	private boolean stretch = false;
	/** 拉伸缩放类型 */
	private Integer imageScaleType = -1;
	/** 提示图片 */
	private String promptImage = "";
	/** 图片圆角半径 */
	private Integer radius = -1;
	/** 图片形状截取遮罩模板，用于制作头像 */
	private String maskImage = "";

	public MetaBaseScript getOnClick() {
		return onClick;
	}

	public void setOnClick(MetaBaseScript onClick) {
		this.onClick = onClick;
	}

//	public boolean isStretch() {
//		return stretch;
//	}
//
//	public void setStretch(boolean stretch) {
//		this.stretch = stretch;
//	}

	public Integer getImageScaleType() {
		return imageScaleType;
	}

	public void setImageScaleType(Integer imageScaleType) {
		this.imageScaleType = imageScaleType;
	}

	public String getPromptImage() {
		return promptImage;
	}

	public void setPromptImage(String promptImage) {
		this.promptImage = promptImage;
	}

	public Integer getRadius() {
		return radius;
	}

	public void setRadius(Integer radius) {
		this.radius = radius;
	}

	public String getMaskImage() {
		return maskImage;
	}

	public void setMaskImage(String maskImage) {
		this.maskImage = maskImage;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		if (onClick != null) {
			list.add(onClick);
		} 
		for (int i = 0; i < size(); i++) {// 设计器使用，不能丢失
			list.add(get(i));
		}
		
		for (int i = 0; i < size(); i++) {
			list.add(get(i));
		}
	}

	@Override
	public String getTagName() {
		return ControlType.STR_IMAGELIST;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (MetaImageListItem.TAG_NAME.equals(tagName)) {
			MetaImageListItem item = new MetaImageListItem();
			item.preProcessMetaObject(env, doc, node, flag, runType);
			add(item);
			resultMetaObject = item;
		} else if (MetaConstants.Event_OnClick.equals(tagName)) {
			onClick = new MetaBaseScript(MetaConstants.Event_OnClick);
			resultMetaObject = onClick;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaImageListProperties newObject = (MetaImageListProperties) super.clone();
		newObject.setOnClick(onClick == null ? null : (MetaBaseScript) onClick.clone());
//		newObject.setStretch(stretch);
		newObject.setImageScaleType(imageScaleType);
		newObject.setPromptImage(promptImage);
		newObject.setRadius(radius);
		newObject.setMaskImage(maskImage);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaImageListProperties();
	}
}
