package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.RollingType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.IPropertyMerger;

/**
 * 数字滚动组件的属性对象
 * 
 * @author chenzs
 *
 */
public class MetaCountUpProperties extends AbstractMetaObject implements IPropertyMerger<MetaCountUpProperties> {

	/** 滚动类型 */
	private Integer rollingType = RollingType.RIGHT;

	/** 滚动行数 */
	private Integer rollingLines = 15;

	/**
	 * 获取滚动类型
	 * 
	 * @return 滚动类型 {@link RollingType}
	 */
	public Integer getRollingType() {
		return rollingType;
	}

	/**
	 * 设置滚动类型
	 * 
	 * @param rollingType
	 */
	public void setRollingType(Integer rollingType) {
		this.rollingType = rollingType;
	}

	/**
	 * 获取滚动行数
	 * 
	 * @return 滚动行数
	 */
	public Integer getRollingLines() {
		return rollingLines;
	}

	/**
	 * 设置滚动行数
	 * 
	 * @param rollingLines
	 */
	public void setRollingLines(Integer rollingLines) {
		this.rollingLines = rollingLines;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {

	}

	@Override
	public String getTagName() {
		return null;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		return null;
	}

	@Override
	public MetaCountUpProperties clone() {
		MetaCountUpProperties newObject = new MetaCountUpProperties();
		newObject.setRollingLines(rollingLines);
		newObject.setRollingType(rollingType);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaCountUpProperties();
	}

	@Override
	public void merge(MetaCountUpProperties properties) {
		if (rollingType == -1) {
			rollingType = properties.getRollingType();
		}
		if (rollingLines == -1) {
			rollingLines = properties.rollingLines;
		}
	}

}
