package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ComboBoxSourceType;
import com.bokesoft.yigo.common.def.ComboFilterType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.IPropertyMerger;
import com.bokesoft.yigo.meta.form.component.control.MetaDefaultItem;

public class MetaComboFilter extends GenericNoKeyCollection<MetaDefaultItem> implements IPropertyMerger<MetaComboFilter> {

	/** 过滤类型，类型为：Exclude、Filter,默认值为Filter*/
    private Integer type = ComboFilterType.Filter;
    
	/** 过滤项来源，支持值为：Items、Formula、Query*/
    private Integer sourceType = ComboBoxSourceType.ITEMS;
    
    /** 表达式表示的过滤项集合 */
    private MetaBaseScript formulaItems = null;
    
	/** 查询来源的查询定义*/
    private MetaQueryDef query = null;
    
	/** 过滤项的依赖*/
    private String itemsDependency = "";

    
    /** 此属性不是配置对象：下拉所依赖的字段*/
    private List<String> dependentFields = new ArrayList<String>();
    /**
     * 获取下拉过滤类型
     * @return 下拉过滤类型值，来源：设置下拉过滤类型
     */
	public Integer getType() {
		return type;
	}

	/**
	 * 设置下拉过滤类型
	 * @param type 下拉过滤类型，来源：设置下拉过滤类型
	 */
	public void setType(Integer type) {
		this.type = type;
	}

	/**
	 * 获取下拉过滤项来源类型
	 * @return 下拉过滤项来源类型,来源：ComboBoxSourceType，支持值：Items、Formula、Query
	 */
	public Integer getSourceType() {
		return sourceType;
	}

	/**
	 * 设置下拉过滤项来源类型
	 * @param sourceType 下拉过滤项来源类型,来源：ComboBoxSourceType，支持值：Items、Formula、Query
	 */
	public void setSourceType(Integer sourceType) {
		this.sourceType = sourceType;
	}

	/**
	 * 取得表达式下拉项
	 * @return 脚本元数据
	 */
	public MetaBaseScript getFormulaItems() {
		return formulaItems;
	}

	/**
	 * 设置表达式下拉项
	 * @param formulaItems
	 */
	public void setFormulaItems(MetaBaseScript formulaItems) {
		this.formulaItems = formulaItems;
	}

	public MetaQueryDef getQueryDef() {
		return query;
	}

	public void setQueryDef(MetaQueryDef query) {
		this.query = query;
	}

	public String getItemsDependency() {
		return itemsDependency;
	}

	public void setItemsDependency(String itemsDependency) {
		this.itemsDependency = "";
        this.dependentFields.clear();
        if(itemsDependency != null && itemsDependency.length() > 0){
            this.itemsDependency = itemsDependency;

            String[] fields = this.itemsDependency.split(",");

            for(String field : fields){
                dependentFields.add(field);
            }
        }
	}
	
	
	
	 /**
     * 载入的时候会将类型为Field的查询参数加入进来,
     * 所以可以直接获取
     *
     * @return 下拉项依赖的字段集合
     */
    public List<String> getDependedFields(){
        return this.dependentFields;
    }
    
    /**
     * 设置依赖列表
     * @param dependentFields 依赖列表
     */
    public void setDependentFields(List<String> dependentFields) {
        this.dependentFields = dependentFields;
    }

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		 addAll(list, new AbstractMetaObject[] { formulaItems,query });
	}

	public static final String TAG_NAME = "ComboFilter";
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaDefaultItem.TAG_NAME.equals(tagName) ) {
			MetaDefaultItem item = new MetaDefaultItem();
			item.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(item);
			resultMetaObject = item;
		}else if ( tagName.equalsIgnoreCase(MetaConstants.COMBOBOX_FORMULAITEMS) ) {
            this.formulaItems = new MetaBaseScript(MetaConstants.COMBOBOX_FORMULAITEMS);
            resultMetaObject = formulaItems;
        }else if(tagName.equalsIgnoreCase(MetaQueryDef.TAG_NAME)){
            this.query = new MetaQueryDef();
            resultMetaObject = query;
        }
		return resultMetaObject;
	}
	
	@Override
    public AbstractMetaObject clone() {
        MetaComboFilter newObject = (MetaComboFilter)super.clone();
        newObject.setFormulaItems(formulaItems == null ? null : (MetaBaseScript)formulaItems.clone());
        newObject.setItemsDependency(itemsDependency);
        newObject.setQueryDef(query == null ? null : (MetaQueryDef)query.clone());
        newObject.setSourceType(this.sourceType);
        newObject.setType(this.type);
        
        newObject.setDependentFields(dependentFields);
        return newObject;
    }

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaComboFilter();
	}
	
	 @Override
    public void doPostProcess(int flag, Callback<AbstractMetaObject,Boolean> callback) throws MetaException {
        super.doPostProcess(flag, callback);
        if(this.query != null){
            query.doPostProcess(flag, callback);

            List<String> list = this.query.getDependedFields();
            if(list != null){
                for(String field : list){
                    if(!this.dependentFields.contains(field)){
                        this.dependentFields.add(field);
                    }
                }
            }
        }
    }

	@Override
	public void merge(MetaComboFilter comboFilter) {
		if( this.type == -1 ) {
			this.type = comboFilter.getType();
		}
		if( this.sourceType == -1 ) {
			this.sourceType = comboFilter.getSourceType();
		}
		if( this.formulaItems == null ) {
			this.formulaItems = comboFilter.getFormulaItems() != null ? (MetaBaseScript) comboFilter.getFormulaItems().clone() : null;
		}
		if( this.query == null ) {
			this.query = comboFilter.getQueryDef() != null ? (MetaQueryDef) comboFilter.getQueryDef().clone() : null;
		}
		if( itemsDependency == null ) {
			this.itemsDependency = comboFilter.getItemsDependency();
		}

		List<String> existItemKeys = new ArrayList<>();
		for (MetaDefaultItem item : comboFilter) {
			existItemKeys.add(item.getKey());
		}

		for (MetaDefaultItem item : this) {
			if (!existItemKeys.contains(item.getKey())) {
				this.add((MetaDefaultItem) item.clone());
			}
		}
	}
}
