package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.LinkedList;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ButtonType;
import com.bokesoft.yigo.common.def.IconLocationType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.IPropertyMerger;
import com.bokesoft.yigo.meta.util.compext.ClassRef;

public class MetaButtonProperties extends AbstractMetaObject implements IPropertyMerger<MetaButtonProperties>{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/** 点击事件 */
	private MetaBaseScript onClick = null;
	
	/** 图标 */
	private String icon = "";
	
	/** 上传文件 */
	private Boolean uploadFile = false;
	
	/** 图片方位*/
	private Integer iconLocation = IconLocationType.LEFT;
	
	/** 是否仅有图片，无文本*/
	private Boolean onlyIcon = false;
	
	/** 是否记录操作日志 */
	private Boolean needAccessLog = false;

	/** 是否需要认证标志--移动端 */
	private Boolean needAuthenticate = false;
	
	/** 点击动画 -- 移动端*/
	private String clickAnim = "";
	
	private String uploadType = "";
	
	/** 按钮类型*/
	@ClassRef(ButtonType.class)
	private Integer type;
	
	private String iconCode;

	/** 事务码 */
	private String tCode = "";
	/** 作业值 */
	private String activity = "";

	private Boolean checkOnClickNode;
	
	public MetaButtonProperties() {
	}

	/**
	 * 设置按钮点击事件
	 * 
	 * @param onClick
	 *            按钮点击事件
	 */
	public void setOnClick(MetaBaseScript onClick) {
		this.onClick = onClick;
	}

	/**
	 * 获取按钮点击事件
	 * 
	 * @return 点击事件
	 */
	public MetaBaseScript getOnClick() {
		return this.onClick;
	}

	/**
	 * 设置按钮图标
	 * @param icon 图标
	 */
	public void setIcon(String icon) {
		this.icon = icon;
	}
	
	/**
	 * 取得按钮图标
	 * @return 图标
	 */
	public String getIcon() {
		return this.icon;
	}

	public Integer getIconLocation() {
		return iconLocation;
	}

	public void setIconLocation(Integer iconLocation) {
		this.iconLocation = iconLocation;
	}

	public Boolean isOnlyIcon() {
		return onlyIcon;
	}

	public void setOnlyIcon(Boolean onlyIcon) {
		this.onlyIcon = onlyIcon;
	}
	
	
	public Boolean getNeedAccessLog() {
		return needAccessLog;
	}
	
	/**
	 * 设置是否需要认证标志
	 * @param needAuthenticate 是否需要认证标志
	 */
	public void setNeedAuthenticate(Boolean needAuthenticate) {
		this.needAuthenticate = needAuthenticate;
	}
	
	/**
	 * 获取是否需要认证标志
	 * @return 是否需要认证标志
	 */
	public Boolean isNeedAuthenticate() {
		return needAuthenticate;
	}

	public void setNeedAccessLog(Boolean needAccessLog) {
		this.needAccessLog = needAccessLog;
	}

	/**
	 * 设置点击动画，目前只支持TabGroup，ImageButton 和 Button，其他组件不支持
	 * @param clickAnim 点击动画类型，参考{@link com.bokesoft.yigo.common.def.ClickAnim}
	 */
	public void setClickAnim(String clickAnim) {
		this.clickAnim = clickAnim;
	}
	
	/**
	 * 获取点击动画，目前只支持TabGroup，ImageButton 和 Button，其他组件不支持
	 * @return 点击动画类型，参考{@link com.bokesoft.yigo.common.def.ClickAnim}
	 */
	public String getClickAnim() {
		return clickAnim;
	}
	
	/**
	 * 设置是否上传文件
	 * @param uploadFile 是否上传文件
	 */
	public void setUploadFile(boolean uploadFile) {
		this.uploadFile = uploadFile;
	}
	
	/**
	 * 获取是否上传文件
	 * @return 是否上传文件
	 */
	public Boolean isUploadFile() {
		return this.uploadFile;
	}
	
	public String getUploadType() {
		return uploadType;
	}

	public void setUploadType(String uploadType) {
		this.uploadType = uploadType;
	}

	/**
	 * 获取按钮类型
	 * @return 按钮类型
	 */
	public Integer getType() {
		return type;
	}

	/**
	 * 设置按钮类型
	 * @param type 按钮类型
	 */
	public void setType(Integer type) {
		this.type = type;
	}
	
	public String getIconCode() {
		return iconCode;
	}

	public void setIconCode(String iconCode) {
		this.iconCode = iconCode;
	}

	/**
	 * 获取事务码
	 * @return
	 */
	public String getTCode() {
		return tCode;
	}

	/**
	 * 设置作业值
	 * @param tCode
	 */
	public void setTCode(String tCode) {
		this.tCode = tCode;
	}

	/**
	 * 获取活动代码
	 * @return
	 */
	public String getActivity() {
		return activity;
	}

	/**
	 * 设置活动代码
	 * @param activity
	 */
	public void setActivity(String activity) {
		this.activity = activity;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		if ( onClick != null ) {
			list.add(onClick);
		}
	}
	
	public Boolean getCheckOnClickNode() {
		return checkOnClickNode;
	}

	public void setCheckOnClickNode(Boolean checkOnClickNode) {
		this.checkOnClickNode = checkOnClickNode;
	}

	@Override
	public String getTagName() {
		return null;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaConstants.Event_OnClick.equals(tagName) ) {
			onClick = new MetaBaseScript(MetaConstants.Event_OnClick);
			resultMetaObject = onClick;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaButtonProperties newObject = (MetaButtonProperties)newInstance();
		newObject.setOnClick(onClick == null ? null : (MetaBaseScript)onClick.clone());
		newObject.setIcon(icon);
		newObject.setIconLocation(iconLocation);
		newObject.setOnlyIcon(onlyIcon);
		newObject.setNeedAccessLog(needAccessLog);
		newObject.setNeedAuthenticate(needAuthenticate);
		newObject.setClickAnim(clickAnim);
		newObject.setUploadFile(uploadFile);
		newObject.setUploadType(uploadType);
		newObject.setType(type);
		newObject.setIconCode(iconCode);
		newObject.setTCode(tCode);
		newObject.setActivity(activity);
		newObject.setCheckOnClickNode(checkOnClickNode);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaButtonProperties();
	}

	@Override
	public void merge(MetaButtonProperties properties) {
		if( this.onClick == null ) {
			this.onClick = properties.getOnClick();
		}
		if( this.icon == null ) {
			this.icon = properties.getIcon();
		}
		if(iconLocation == -1){
			this.iconLocation = properties.getIconLocation();
		}
		if(onlyIcon == null){
			this.onlyIcon = properties.isOnlyIcon();
		}
		// TODO: needAccessLog
		if(needAuthenticate == null){
			needAuthenticate = properties.isNeedAuthenticate();
		}
		if(clickAnim == null){
			clickAnim = properties.getClickAnim();
		}
		if(uploadFile == null) {
			uploadFile = properties.isUploadFile();
		}
		if(uploadType == null) {
			uploadType = properties.getUploadType();
		}
		if (type == null) {
			type = properties.getType();
		}
		if (iconCode == null) {
			iconCode = properties.getIconCode();
		}
		if( this.tCode == null) {
			this.tCode = properties.getTCode();
		}
		if( this.activity == null) {
			this.activity = properties.getActivity();
		}
		if (this.checkOnClickNode == null) {
			this.checkOnClickNode = properties.getCheckOnClickNode();
		}
	}
}