package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.IPropertyMerger;

public class MetaBPMGraphProperties extends AbstractMetaObject implements IPropertyMerger<MetaBPMGraphProperties> {
	/** 流程图标记，用于区分不同的实现 */
	private String viewTag = "";
	/** 关联的执行记录表标识 */
	private String tableKey = "";
	/** 流程标识表达式 */
	private String processKey = "";
	/** 流程版本表达式 */
	private String processVer = "";
	/** 获取当前流程流转路径*/
	private String processPath = "";
	/** OID表达式*/
	private String OID = "";

	public MetaBPMGraphProperties() {
		super();
	}

	/**
	 * 设置流程图标记
	 * @param viewTag 流程图标记
	 */
	public void setViewTag(String viewTag) {
		this.viewTag = viewTag;
	}

	/**
	 * 取得流程图标记
	 * @return 流程图标记
	 */
	public String getViewTag() {
		return this.viewTag;
	}

	/**
	 * 设置表标识
	 * @param tableKey 表标识
	 */
	public void setTableKey(String tableKey) {
		this.tableKey = tableKey;
	}

	/**
	 * 取得表标识
	 * @return 表标识
	 */
	public String getTableKey() {
		return this.tableKey;
	}

	/**
	 * 设置流程标识
	 * @param processKey 流程标识
	 */
	public void setProcessKey(String processKey) {
		this.processKey = processKey;
	}

	/**
	 * 取得流程标识
	 * @return 流程标识
	 */
	public String getProcessKey() {
		return this.processKey;
	}

	/**
	 * 设置流程版本
	 * @param processVer 流程版本
	 */
	public void setProcessVer(String processVer) {
		this.processVer = processVer;
	}

	/**
	 * 取得流程版本
	 * @return 流程版本
	 */
	public String getProcessVer() {
		return this.processVer;
	}

	/**
	 * 设置过程路径
	 * @param processPath 过程路径
	 */
	public void setProcessPath(String processPath) {
		this.processPath = processPath;
	}

	/**
	 * 取得过程路径
	 * @return 过程路径
	 */
	public String getProcessPath() {
		return this.processPath;
	}
	
	/**
	 * 设置OID表达式
	 * @param oID
	 */
	public void setOID(String oID) {
		OID = oID;
	}

	/**
	 * 获取OID表达式
	 * @return
	 */
	public String getOID() {
		return OID;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return null;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
													Object node, String tagName, Object flag, int runType) throws MetaException {
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaBPMGraphProperties newObject = new MetaBPMGraphProperties();
		newObject.setViewTag(viewTag);
		newObject.setTableKey(tableKey);
		newObject.setProcessKey(processKey);
		newObject.setProcessVer(processVer);
		newObject.setProcessPath(processPath);
		newObject.setOID(OID);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaBPMGraphProperties();
	}

	@Override
	public void merge(MetaBPMGraphProperties metaBPMGraphProperties) {
		if( this.viewTag == null ) {
			this.viewTag = metaBPMGraphProperties.getViewTag();
		}
		if( this.tableKey == null ) {
			this.tableKey = metaBPMGraphProperties.getTableKey();
		}
		if( this.processKey == null ) {
			this.processKey = metaBPMGraphProperties.getProcessKey();
		}
		if( this.processVer == null ) {
			this.processVer = metaBPMGraphProperties.getProcessVer();
		}
		if( this.processPath == null ) {
			this.processPath = metaBPMGraphProperties.getProcessPath();
		}
		if( this.OID == null ) {
			this.OID = metaBPMGraphProperties.getOID();
		}
	}
}
