package com.bokesoft.yigo.meta.form.component.control.progressindicator;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.ProgressIndicatorSourceType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaProgressIndicatorProperties;

/**
 * 进度指示器组件
 * @author chenzs
 *
 */
public class MetaProgressIndicator extends MetaComponent {

	public static final String TAG_NAME = ControlType.STR_PROGRESSINDICATOR;
	/**
	 * 属性对象
	 */
	private MetaProgressIndicatorProperties properties = new MetaProgressIndicatorProperties();

	/**
	 * 获取来源类型
	 *
	 * @return 来源类型，取值范围为{@link ProgressIndicatorSourceType}
	 */
	public Integer getSourceType() {
		return properties.getSourceType();
	}

	/**
	 * 设置来源类型
	 *
	 * @param sourceType 来源类型，取值范围为{@link ProgressIndicatorSourceType}
	 */
	public void setSourceType(Integer sourceType) {
		properties.setSourceType(sourceType);
	}

	/**
	 * 获取数据表标识
	 *
	 * @return 数据表标识
	 */
	public String getDataTableKey() {
		return properties.getTableKey();
	}

	/**
	 * 设置数据表标识
	 *
	 * @param tableKey 数据表标识
	 */
	public void setDataTableKey(String tableKey) {
		properties.setTableKey(tableKey);
	}

	/**
	 * 获取标题列标识
	 *
	 * @return 标题列标识
	 */
	public String getTitleColumnKey() {
		return properties.getTitleColumnKey();
	}

	/**
	 * 设置标题列标识
	 *
	 * @param titleColumnKey 标题列标识
	 */
	public void setTitleColumnKey(String titleColumnKey) {
		properties.setTitleColumnKey(titleColumnKey);
	}

	/**
	 * 获取内容列标识
	 *
	 * @return 内容列标识
	 */
	public String getMessageColumnKey() {
		return properties.getMessageColumnKey();
	}

	/**
	 * 设置内容列标识
	 *
	 * @param messageColumnKey 内容列标识
	 */
	public void setMessageColumnKey(String messageColumnKey) {
		properties.setMessageColumnKey(messageColumnKey);
	}

	/**
	 * 获取时间列标识
	 *
	 * @return 时间列标识
	 */
	public String getDataTimeColumnKey() {
	  return   properties.getDateTimeColumnKey();
	}

	/**
	 * 设置时间列标识
	 *
	 * @param dataTimeColumnKey 时间列标识
	 */
	public void setDataTimeColumnKey(String dataTimeColumnKey) {
		properties.setDateTimeColumnKey(dataTimeColumnKey);
	}

	/**
	 * 是否倒序绘制 
	 * @return 是否倒序绘制 
	 */
	public Boolean isReverseDraw() {
		return properties.isReverseDraw();
	}

	/**
	 * 设置是否倒序绘制
	 * @param reverseDraw 设置是否倒序绘制
	 */
	public void setReverseDraw(Boolean reverseDraw) {
		properties.setReverseDraw(reverseDraw);
	}

	/**
	 * 获取显示方向
	 * @return  显示方向
	 */
	public Integer getOrientation() {
		return properties.getOrientation();
	}

	/**
	 * 设置显示方向
	 * @param orientation 显示方向
	 */
	public void setOrientation(Integer orientation) {
		properties.setOrientation(orientation);
	}

	/**
	 * 获取完成时节点图标
	 * @return 完成时节点图标
	 */
	public String getCompletedIcon() {
		return properties.getCompletedIcon();
	}

	/**
	 * 设置完成时节点图片
	 * @param completedIcon 完成时节点图片
	 */
	public void setCompletedIcon(String completedIcon) {
		properties.setCompletedIcon(completedIcon);
	}

	/**
	 * 获取进行中节点图标
	 * @return 进行中节点图标
	 */
	public String getAttentionIcon() {
		return properties.getAttentionIcon();
	}

	/**
	 * 设置进行中节点图标
	 * @param attentionIcon 进行中节点图标
	 */
	public void setAttentionIcon(String attentionIcon) {
		properties.setAttentionIcon(attentionIcon);
	}
	
	/**
	 * 获取进行中节点的文本颜色
	 * @return 进行中节点的文本颜色
	 */
	public String getAttentionTextColor() {
		return properties.getAttentionTextColor();
	}
	
	/**
	 * 设置进行中节点的文本颜色
	 * @param attentionTextColor 进行中节点的文本颜色
	 */
	public void setAttentionTextColor(String attentionTextColor) {
		properties.setAttentionTextColor(attentionTextColor);
	}

	/**
	 * 获取未完成时节点默认图标
	 * @return 未完成时节点默认图标
	 */
	public String getDefaultIcon() {
		return properties.getDefaultIcon();
	}

	/**
	 * 设置未完成时节点默认图标
	 * @param defaultIcon 未完成时节点默认图标
	 */
	public void setDefaultIcon(String defaultIcon) {
		properties.setDefaultIcon(defaultIcon);
	}

	/**
	 * 获取未完成时节点连线的颜色
	 * @return 未完成时节点连线的颜色
	 */
	public String getUnCompletedLineColor() {
		return properties.getUnCompletedLineColor();
	}

	/**
	 * 设置未完成时节点连线的颜色
	 * @param unCompletedLineColor 未完成时节点连线的颜色
	 */
	public void setUnCompletedLineColor(String unCompletedLineColor) {
		properties.setUnCompletedLineColor(unCompletedLineColor);
	}

	/**
	 * 获取未完成时节点文本的颜色
	 * @return 未完成时节点文本的颜色
	 */
	public String getUnCompletedTextColor() {
		return properties.getUnCompletedTextColor();
	}

	/**
	 * 设置未完成时节点文本的颜色
	 * @param unCompletedTextColor 未完成时节点文本的颜色
	 */
	public void setUnCompletedTextColor(String unCompletedTextColor) {
		properties.setUnCompletedTextColor(unCompletedTextColor);
	}

	/**
	 * 获取完成时节点连线的颜色
	 * @return 完成时节点连线的颜色
	 */
	public String getCompletedLineColor() {
		return properties.getCompletedLineColor();
	}

	/**
	 * 设置完成时节点连线的颜色
	 * @param completedLineColor 完成时节点连线的颜色
	 */
	public void setCompletedLineColor(String completedLineColor) {
		properties.setCompletedLineColor(completedLineColor);
	}

	/**
	 * 获取完成时节点文本的颜色
	 * @return 完成时节点文本的颜色
	 */
	public String getCompletedTextColor() {
		return properties.getCompletedTextColor();
	}

	/**
	 * 设置完成时节点文本的颜色
	 * @param completedTextColor 完成时节点文本的颜色
	 */
	public void setCompletedTextColor(String completedTextColor) {
		properties.setCompletedTextColor(completedTextColor);
	}

	/**
	 * 获取进度刻度项集合
	 * @return 进度刻度项集合
	 */
	public MetaProgressItemCollection getMetaProgressItemCollection() {
		return properties.getMetaProgressItemCollection();
	}

	/**
	 * 设置进度刻度项集合
	 * @param collection 进度刻度项集合
	 */
	public void setMetaProgressItemCollection(MetaProgressItemCollection collection) {
		properties.setMetaProgressItemCollection(collection);
	}
	
	/**
	 * 是否可滚动，默认为true
	 * @return 是否可滚动
	 */
	public Boolean isScroll(){
		return properties.isScroll();
	}

	/**
	 * 设置是否可滚动，默认为true
	 * @param scroll 是否可滚动
	 */
	public void setScroll(Boolean scroll){
		properties.setScroll(scroll);
	}

	@Override
	public int getControlType() {
		return ControlType.PROGRESSINDICATOR;
	}

	@Override
	public AbstractMetaObject getProperties() {
		return properties;
	}

	/**
	 * 设置属性对象
	 * @param properties 属性对象
	 */
	public void setProperties(AbstractMetaObject properties) {
		this.properties = (MetaProgressIndicatorProperties) properties;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaProgressIndicator();
	}

	@Override
	public AbstractMetaObject clone() {
		MetaProgressIndicator metaProgressIndicator = (MetaProgressIndicator) super.clone();
		metaProgressIndicator.setProperties((MetaProgressIndicatorProperties) properties.clone());
		return metaProgressIndicator;
	}
}
