package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.MetaComponent;


/**
 * 时区日期控件
 * 
 * 数据存储
 * 格式：YYYY-MM-DD HH:mm:ss TimeZone
 * 例如：2020-04-13 11:32:01 Asia/Shanghai
 * 
 * @author lishu
 *
 */

public class MetaTimeZoneDatePicker extends MetaComponent{
	
	/** 配置文件中对应的节点的标签名称 */
	public static final String TAG_NAME = ControlType.STR_TIMEZONEDATEPICKER;
	
	/** 是否显示时差
	 * 
	 * 例如：Asia/Shanghai 时差 GMT +8:00
	 * 显示：2020-04-13 11:32:01 GMT +8:00
	 */
	private Boolean showTimeOff =  false;

	@Override
	public int getControlType() {
		// TODO Auto-generated method stub
		return ControlType.TIMEZONEDATEPICKER;
	}

	@Override
	public AbstractMetaObject getProperties() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getTagName() {
		// TODO Auto-generated method stub
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject newInstance() {
		// TODO Auto-generated method stub
		return new MetaTimeZoneDatePicker();
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaTimeZoneDatePicker newObject = (MetaTimeZoneDatePicker)super.clone();
		newObject.setShowTimeOff(this.showTimeOff);
		return newObject;
	}
	
	/**
	 * 	是否显示时差
	 * 
	 * @return 是否显示时差
	 */
	public Boolean isShowTimeOff() {
		return showTimeOff;
	}
	
	/**
	 * 设置是否显示时差
	 * 
	 * @param showTimeOff 是否显示时差
	 */
	public void setShowTimeOff(Boolean showTimeOff) {
		this.showTimeOff = showTimeOff;
	}
	
}
