package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaTextButtonProperties;

/**
 * 文本按钮配置对象，即一个文本框带一个按钮，比如搜索框
 * 
 * @author chenzs
 * @since YES1.0
 */
public class MetaTextButton extends MetaComponent {

	/** 配置文件中对应的节点的标签名称 */
	public static final String TAG_NAME = ControlType.STR_TEXTBUTTON;

	/** 大小写类型——无限制 */
	public static final int CASETYPE_NONE = 0;
	/** 大小写类型——全小写 */
	public static final int CASETYPE_LOWER = 1;
	/** 大小写类型——全大写 */
	public static final int CASETYPE_UPPER = 2;

	private MetaTextButtonProperties properties = new MetaTextButtonProperties();
	
	public void setProperties(AbstractMetaObject properties) {
		this.properties = (MetaTextButtonProperties) properties;
	}

	/**
	 * 设置最大输入字符长度
	 * 
	 * @param length
	 *            最大输入字符长度
	 */
	public void setMaxLength(Integer length) {
		this.properties.setMaxLength(length);
	}

	/**
	 * 获取最大输入字符长度
	 * 
	 * @return 最大输入字符长度
	 */
	public Integer getMaxLength() {
		return this.properties.getMaxLength();
	}
	
	/**
	 * 设置是否去除空格
	 * @param trim 标志
	 */
	public void setTrim(Boolean trim) {
		this.properties.setTrim(trim);
	}
	
	/**
	 * 获取是否去除空格
	 * @return 是否去除空格
	 */
	public Boolean trim() {
		return this.properties.isTrim();
	}

	/**
	 * 设置不允许输入的字符集合
	 * 
	 * @param chars
	 *            不允许输入的字符集合
	 */
	public void setInvalidChars(String chars) {
		this.properties.setInvalidChars(chars);
	}

	/**
	 * 获取不允许输入的字符集合
	 * 
	 * @return 不允许输入的字符集合
	 */
	public String getInvalidChars() {
		return this.properties.getInvalidChars();
	}

	/**
	 * 设置大小写转换类型
	 * 
	 * @param caseType
	 *            大小写转换类型
	 * @see #CASETYPE_NONE
	 * @see #CASETYPE_LOWER
	 * @see #CASETYPE_UPPER
	 */
	public void setCaseType(Integer caseType) {
		this.properties.setCaseType(caseType);
	}

	/**
	 * 获取大小写转换类型
	 * 
	 * @return 大小写转换类型
	 * @see #CASETYPE_NONE
	 * @see #CASETYPE_LOWER
	 * @see #CASETYPE_UPPER
	 * 
	 */
	public Integer getCaseType() {
		return this.properties.getCaseType();
	}

	/**
	 * 通过转换类型字符串获取大小写转换类型
	 * 
	 * @param type
	 *            字符串
	 * @return 大小写转换类型
	 */
	public static int parseCaseType(String type) {
		if (type.equalsIgnoreCase("Lower")) {
			return CASETYPE_LOWER;
		} else if (type.equalsIgnoreCase("Upper")) {
			return CASETYPE_UPPER;
		}
		return CASETYPE_NONE;
	}

	/**
	 * 获取大小写转换类型字符串
	 * @param type 大小写转换类型
	 * @return 大小写转换类型字符串
	 */
	public static String getCaseTypeStr(int type) {
		if (type == CASETYPE_LOWER) {
			return "Lower";
		} else if (type == CASETYPE_UPPER) {
			return "Upper";
		}
		return "None";
	}

	/**
	 * 设置文本为空时的提示信息
	 * 
	 * @param promptText
	 *            提示信息
	 */
	public void setPromptText(String promptText) {
		this.properties.setPromptText(promptText);
	}

	/**
	 * 获取文本为空时的提示信息
	 * 
	 * @return 提示信息
	 */
	public String getPromptText() {
		return this.properties.getPromptText();
	}

	/**
	 * 获取按钮点击事件
	 * 
	 * @return 按钮点击事件
	 */
	public MetaBaseScript getOnClick() {
		return this.properties.getOnClick();
	}
	
	/**
	 * 获取焦点是否全选
	 * @return 标志
	 */
	public Boolean selectOnFocus() {
		return this.properties.isSelectOnFocus();
	}
	
	/**
	 * 取得回车事件处理定义
	 * @return 处理定义
	 */
	public MetaBaseScript getKeyEnter(){
		return this.properties.getKeyEnter();
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.TEXTBUTTON;
	}
	
//	@Override
//	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node,
//			String tagName, Object flag) throws MetaException {
//		AbstractMetaObject resultMetaObject = null;
//		if (MetaConstants.Event_OnClick.equals(tagName)) {
//			onClick = new MetaBaseScript(MetaConstants.Event_OnClick);
//			resultMetaObject = onClick;
//		}
//		if ( resultMetaObject == null ) {
//			resultMetaObject = super.createChildMetaObject(env, doc, node, tagName, flag);
//		}
//		return resultMetaObject;
//	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaTextButton newObject = (MetaTextButton)super.clone();
		newObject.setProperties((MetaTextButtonProperties)properties.clone());
		
//		newObject.setOnClick(onClick == null ? null : (MetaBaseScript)onClick.clone());

		return newObject;
	}
	
	@Override
	public AbstractMetaObject newInstance() {
		return new MetaTextButton();
	}

	@Override
	public AbstractMetaObject getProperties() {
		return this.properties;
	}

}
