package com.bokesoft.yigo.meta.form.component.control;

import java.util.LinkedList;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.MetaFormat;

/**
 * 选项卡选项
 * @author wangyh
 *
 */
public class MetaTabItem extends KeyPairMetaObject {
	/** 文本 */
	private String text = "";
	/** 图标 */
	private String icon = "";
	/** 表单标识 */
	private String formKey = "";
	/** 切换事件 */
	private MetaBaseScript action = null;
	/** 点击事件 */
	private MetaBaseScript onClick = null;
	/** 选中状态图标 */
	private String selectedIcon = "";
	/** 格式*/
	private MetaFormat format = null;
	/** 点击动画，移动端使用，目前值可用值为：1）Scale*/
	private String clickAnim = "";
	/** 选项卡选项标识*/
	private String key = "";
	/** 选项卡选项可见性*/
	private String visible = "";
	/** 选项卡选项可见性依赖*/
	private String visibleDependency = "";
	
	
	public MetaTabItem() {
		super();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		list.add(action);
		list.add(onClick);
		if(format != null)
			list.add(format);
	}

	public static final String TAG_NAME = "TabItem";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	/**
	 * 设置文本
	 * @param text 文本
	 */
	public void setText(String text) {
		this.text = text;
	}
	
	/**
	 * 取得文本
	 * @return 文本
	 */
	public String getText() {
		return this.text;
	}
	
	/**
	 * 设置图标
	 * @param icon 图标
	 */
	public void setIcon(String icon) {
		this.icon = icon;
	}
	
	/**
	 * 取得图标
	 * @return 图标
	 */
	public String getIcon() {
		return this.icon;
	}
	
	/**
	 * 设置表单标识
	 * @param formKey 表单标识
	 */
	public void setFormKey(String formKey) {
		this.formKey = formKey;
	}
	
	/**
	 * 取得表单标识
	 * @return 表单标识
	 */
	public String getFormKey() {
		return this.formKey;
	}
	
	/**
	 * 设置切换事件
	 * @param action 切换事件
	 */
	public void setAction(MetaBaseScript action) {
		this.action = action;
	}
	
	/**
	 * 取得切换事件
	 * @return 切换事件
	 */
	public MetaBaseScript getAction() {
		return this.action;
	}
	
	/**
	 * 设置点击事件
	 * @param onClick 点击事件
	 */
	public void setOnClick(MetaBaseScript onClick) {
		this.onClick = onClick;
	}
	
	/**
	 * 获取点击事件
	 * @return 点击事件
	 */
	public MetaBaseScript getOnClick() {
		return onClick;
	}
	
	/**
	 * 取得选中状态图标
	 * @return 选中状态
	 */
	public String getSelectedIcon() {
		return selectedIcon;
	}
	
	/**
	 * 设置 选中状态图标
	 * @param selectedIcon  选中状态图标
	 */
	public void setSelectedIcon(String selectedIcon) {
		this.selectedIcon = selectedIcon;
	}
	
	/**
	 * 获取格式
	 * @return 格式，参考{@link MetaFormat}
	 */
	public MetaFormat getFormat() {
		return format;
	}

	/**
	 * 设置格式
	 * @param format 格式，参考{@link MetaFormat}
	 */
	public void setFormat(MetaFormat format) {
		this.format = format;
	}

	/**
	 * 获取点击动画
	 * @return 点击动画，移动端使用，目前值可用值为：1）Scale
	 */
	public String getClickAnim() {
		return clickAnim;
	}

	/**
	 * 设置点击动画
	 * @param clickAnim 点击动画，移动端使用，目前值可用值为：1）Scale
	 */
	public void setClickAnim(String clickAnim) {
		this.clickAnim = clickAnim;
	}

	/**
	 * 获取选项标识
	 * @return 选项标识
	 */
	public String getKey() {
		return key;
	}

	/**
	 * 设置选项标识
	 * @param key 选项标识
	 */
	public void setKey(String key) {
		this.key = key;
	}

	/**
	 * 获取选项可见性
	 * @return 选项可见性
	 */
	public String getVisible() {
		return visible;
	}

	/**
	 * 设置选项可见性
	 * @param visible 选项可见性
	 */
	public void setVisible(String visible) {
		this.visible = visible;
	}

	/**
	 * 获取选项可见性依赖
	 * @return 选项可见性依赖
	 */
	public String getVisibleDependency() {
		return visibleDependency;
	}

	/**
	 * 设置选项可见性依赖
	 * @param visibleDependency 选项可见性依赖
	 */
	public void setVisibleDependency(String visibleDependency) {
		this.visibleDependency = visibleDependency;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaConstants.Event_Action.equals(tagName) ) {
			this.action = new MetaBaseScript(MetaConstants.Event_Action);
			resultMetaObject = this.action;
		}else if ( MetaConstants.Event_OnClick.equals(tagName) ) {
			this.onClick = new MetaBaseScript(MetaConstants.Event_OnClick);
			resultMetaObject = this.onClick;
		}else if(tagName.equals(MetaFormat.TAG_NAME)){
			format = new MetaFormat();
			resultMetaObject = format;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaTabItem newObject = (MetaTabItem)newInstance();
		newObject.setKey(key);
		newObject.setText(text);
		newObject.setIcon(icon);
		newObject.setFormKey(formKey);
		newObject.setAction(action == null ? null : (MetaBaseScript)action.clone());
		newObject.setAction(onClick == null ? null : (MetaBaseScript)onClick.clone());
		newObject.setFormat(format == null ? null : (MetaFormat)format.clone());
		newObject.setSelectedIcon(selectedIcon);
		newObject.setClickAnim(clickAnim);
		newObject.setVisible(visible);
		newObject.setVisibleDependency(visibleDependency);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaTabItem();
	}


	@Override
	public boolean needPreLoad() {
		return false;
	}
}
