package com.bokesoft.yigo.meta.form.component.control;

import java.math.BigDecimal;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.StepEditorEditType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaStepEditorProperties;

public class MetaStepEditor extends MetaComponent {
private MetaStepEditorProperties properties = new MetaStepEditorProperties();
	
	public MetaStepEditor() {
		super();
	}
	
	/** 配置文件中对应的节点的标签名称 */
	public static final String TAG_NAME = ControlType.STR_STEPEDITOR;

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.STEPEDITOR;
	}
	
	/**
	 * 获取步进值
	 * @return 步进值，默认值为1
	 */
	public BigDecimal getStep() {
		return this.properties.getStep();
	}

	/**
	 * 设置步进值
	 * @param step 步进值
	 */
	public void setStep(BigDecimal step) {
		this.properties.setStep(step);
	}


	/**
	 * 设置最小值
	 * @param minValue 最小值
	 */
	public void setMinValue(BigDecimal minValue) {
		this.properties.setMinValue(minValue);
	}

	/**
	 * 获取最小值
	 * @return 最小值
	 */
	public BigDecimal getMinValue() {
		return this.properties.getMinValue();
	}

	/**
	 * 设置最大值
	 * @param maxValue 最大值
	 */
	public void setMaxValue(BigDecimal maxValue) {
		this.properties.setMaxValue(maxValue);
	}

	/**
	 * 获取最大值
	 * @return 最大值
	 */
	public BigDecimal getMaxValue() {
		return this.properties.getMaxValue();
	}

	/**
	 * 设置计步器显示样式
	 * @param showType
	 */
	public void setShowType(Integer showType) {
		this.properties.setShowType(showType);
	}
	
	/**
	 * 获取控件显示样式
	 * @return
	 */
	public Integer getShowType() {
		return properties.getShowType();
	}
	
	/**
	 * 获取编辑样式
	 * @return 编辑样式，取值参考{@link StepEditorEditType}
	 */
	public Integer getEditType() {
		return properties.getEditType();
	}

	/**
	 * 设置编辑样式
	 * @param editType 编辑样式，取值参考{@link StepEditorEditType}
	 */
	public void setEditType(Integer editType) {
		this.properties.setEditType(editType);
	}

	/**
	 * 设置是否禁用软键盘，针对带有输入框的组件
	 * @param disableKeyboard 是否禁用软键盘
	 */
	public void setDisableKeyboard(Boolean disableKeyboard) {
		this.properties.setDisableKeyboard(disableKeyboard);
	}
	
	/**
	 * 获取是否禁用软键盘，针对带有输入框的组件
	 * @return 是否禁用软键盘
	 */
	public Boolean isDisableKeyboard() {
		return properties.isDisableKeyboard();
	}

	@Override
	public AbstractMetaObject clone() {
		MetaStepEditor newObject = (MetaStepEditor)super.clone();
		newObject.setProperties((MetaStepEditorProperties)properties.clone());
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaStepEditor();
	}

	@Override
	public MetaStepEditorProperties getProperties() {
		return properties;
	}
	
	public void setProperties(AbstractMetaObject properties) {
		this.properties = (MetaStepEditorProperties) properties;
	}
}
