package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaImageListProperties;

public class MetaImageList extends MetaComponent {

	public static final String TAG_NAME = ControlType.STR_IMAGELIST;

	private MetaImageListProperties properties = new MetaImageListProperties();

	public MetaBaseScript getOnClick() {
		return properties.getOnClick();
	}

	public void setOnClick(MetaBaseScript onClick) {
		this.properties.setOnClick(onClick);
	}

//	public boolean isStretch() {
//		return properties.isStretch();
//	}

//	public void setStretch(boolean stretch) {
//		this.properties.setStretch(stretch);
//	}

	public Integer getImageScaleType() {
		return properties.getImageScaleType();
	}

	public void setImageScaleType(Integer imageScaleType) {
		this.properties.setImageScaleType(imageScaleType);
	}

	public String getPromptImage() {
		return properties.getPromptImage();
	}

	public void setPromptImage(String promptImage) {
		this.properties.setPromptImage(promptImage);
	}

	public Integer getRadius() {
		return properties.getRadius();
	}

	public void setRadius(Integer radius) {
		this.properties.setRadius(radius);
	}

	public String getMaskImage() {
		return properties.getMaskImage();
	}

	public void setMaskImage(String maskImage) {
		this.properties.setMaskImage(maskImage);
	}

	public MetaImageListItem getItem(String key) {
		return properties.get(key);
	}

	public MetaImageListItem getItem(int index) {
		return properties.get(index);
	}
	
	public int getItemCount() {
		return properties.size();
	}

	@Override
	public int getControlType() {
		return ControlType.IMAGELIST;
	}

	public void setProperties(AbstractMetaObject properties) {
		this.properties = (MetaImageListProperties) properties;
	}

	@Override
	public AbstractMetaObject getProperties() {
		return properties;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaImageList newObj = (MetaImageList) super.clone();
		newObj.setProperties(properties == null ? null : (MetaImageListProperties)properties.clone());
		return newObj;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaImageList();
	}
}
