package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.DictStateMask;
import com.bokesoft.yigo.common.def.SelectEditType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDictSearchBoxProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaItemFilterCollection;

/**
 * 字典配置对象
 * 
 * @author my
 * @since YES1.0
 */
public class MetaDictSearchBox extends MetaComponent {
	protected MetaDictSearchBoxProperties properties = new MetaDictSearchBoxProperties();

	/** 配置文件中对应的节点的标签名称 */
	public static final String TAG_NAME = ControlType.STR_DICTSEARCHBOX;
	
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.DICTSEARCHBOX;
	}
	/**
	 * 设置按钮点击事件
	 * 
	 * @param onClick
	 *            按钮点击事件
	 */
	public void setOnClick(MetaBaseScript onClick) {
		properties.setOnClick(onClick);
	}

	/**
	 * 获取按钮点击事件
	 * 
	 * @return 点击事件
	 */
	public MetaBaseScript getOnClick() {
		return properties.getOnClick();
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaDictSearchBox newObject = (MetaDictSearchBox)super.clone();
		newObject.setProperties((MetaDictSearchBoxProperties)properties.clone());
		return newObject;
	}

	@Override
	public AbstractMetaObject getProperties() {
		return properties;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaDictSearchBox();
	}
	/**
	 * 设置字典关联对象的标识
	 * 
	 * @param key
	 *            关联对象标识
	 */
	public void setItemKey(String key) {
		this.properties.setItemKey(key);
	}

	/**
	 * 获取字典关联对象的标识
	 * 
	 * @return 关联对象标识
	 */
	public String getItemKey() {
		return this.properties.getItemKey();
	}

	/**
	 * 设置是否允许多选
	 * 
	 * @param allow
	 *            是否允许多选
	 */
	public void setAllowMultiSelection(Boolean allow) {
		this.properties.setAllowMultiSelection(allow);
	}

	/**
	 * 获取是否允许多选
	 * 
	 * @return 是否允许多选
	 */
	public Boolean isAllowMultiSelection() {
		return this.properties.isAllowMultiSelection();
	}

	/**
	 * 设置是否为父子节点联动
	 * 
	 * @param independent
	 *            是否为父子节点联动
	 */
	public void setIndependent(Boolean independent) {
		this.properties.setIndependent(independent);
	}

	/**
	 * 获取是否为父子节点联动
	 * 
	 * @return 是否为父子节点联动
	 */
	public Boolean isIndependent() {
		return this.properties.isIndependent();
	}

	/**
	 * 设置是否忽略权限
	 *
	 * @param isIgnoreRights 是否忽略权限，默认值为{@link #isIgnoreRights}
	 */
	public void setIgnoreRights(Boolean isIgnoreRights) {
		this.properties.setIgnoreRights(isIgnoreRights);
	}

	/**
	 * 获取是否忽略权限
	 *
	 * @return 是否忽略权限，默认值为{@link #isIgnoreRights}
	 */
	public Boolean isIgnoreRights() {
		return this.properties.isIgnoreRights();
	}

	/**
	 * 取得过滤条件集合
	 *
	 * @return 过滤条件集合
	 */
	public MetaItemFilterCollection getFilters() {
		return properties.getFilters();
	}	

	/**
	 * 获取状态过滤
	 *
	 * @return 状态过滤，取值范围为{@link DictStateMask}
	 */
	public int getStateMask(){
		return properties.getStateMask();
	}
	
	/**
	 * 设置状态过滤
	 *
	 * @param stateMask 状态过滤，取值范围为{@link DictStateMask}
	 */
	public void setStateMask(int stateMask){
		properties.setStateMask(stateMask);
	}

	/**
	 * 设置字典根节点
	 * @param root 字典根节点
	 */
	public void setRoot(String root) {
		properties.setRoot(root);
	}
	
	/**
	 * 获取字典根节点 
	 * @return 字典根节点
	 */
	public String getRoot() {
		return properties.getRoot();
	}
	
	/**
	 * 获取编辑样式
	 *
	 * @return 编辑样式，取值范围为{@link SelectEditType}
	 */
	public int getEditType() {
		return properties.getEditType();
	}

	/**
	 * 设置编辑样式
	 *
	 * @param editType 编辑样式，取值范围为{@link SelectEditType}
	 */
	public void setEditType(int editType) {
		properties.setEditType(editType);
	}

	/**
	 * 获取是否允许编辑输入框，仅{@link MetaComponent#getEnable()}为true及
	 * {@link MetaComponent#isOnlyShow()}为false时生效
	 *
	 * @return 是否允许编辑输入框
	 */
	public boolean isEditable() {
		return properties.isEditable();
	}

	/**
	 * 设置是否允许编辑输入框，仅{@link MetaComponent#getEnable()}为true及
	 * {@link MetaComponent#isOnlyShow()}为false时生效
	 *
	 * @param editable 是否允许编辑输入框
	 */
	public void setEditable(boolean editable) {
		properties.setEditable(editable);
	}
	
}
