package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaAttachmentProperties;

public class MetaAttachment extends MetaComponent {
	public MetaAttachment() {
		super();
	}
	
	private MetaAttachmentProperties properties = new MetaAttachmentProperties();
	
	@Override
	public int getControlType() {
		return ControlType.ATTACHMENT;
	}

	@Override
	public AbstractMetaObject getProperties() {
		return properties;
	}
	
	public void setProperties(AbstractMetaObject properties) {
		this.properties = (MetaAttachmentProperties) properties;
	}

	public static final String TAG_NAME = ControlType.STR_ATTACHMENT;
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	public void setImpl(String impl){
		this.properties.setImpl(impl);
	}
	
	public String getImpl(){
		return this.properties.getImpl();
	}
	
	public String getTableKey() {
		return this.properties.getTableKey();
	}
	
	public void setTableKey(String tableKey){
		this.properties.setTableKey(tableKey);
	}

	public Integer getMaxSize() {
		return this.properties.getMaxSize();
	}
	
	public String getAllowedTypes() {
		return this.properties.getAllowedTypes();
	}

	public void setMaxSize(Integer maxSize) {
		this.properties.setMaxSize(maxSize);
	}
	
	public String getProvider(){
		return this.properties.getProvider();
	}

	public void setProvider(String provider){
		this.properties.setProvider(provider);
	}
	
	public Boolean isPreview() {
		return this.properties.isPreview();
	}

	public void setPreview(boolean preView) {
		this.properties.setPreview(preView);;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaAttachment();
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaAttachment newObject = (MetaAttachment)super.clone();
		newObject.setProperties((MetaAttachmentProperties)properties.clone());
		return newObject;
	}

}
