package com.bokesoft.yigo.meta.form.component.chart;

import java.util.LinkedList;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ChartType;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.MetaComponent;

public class MetaChart extends MetaComponent {
	/**
	 * 图表类型，取值见{@link com.bokesoft.yigo.common.def.ChartType}
	 */
	private Integer chartType = ChartType.Line;
	/** 
	 * 图表的数据来源类型，取值见{@link com.bokesoft.yigo.common.def.ChartSourceType}
	 */
	private Integer sourceType = -1;
	/** 图表的标题 */
	private String title = "";
	/** 系列在行标志 */
	private Boolean seriesInRow = false;
	/** 系列轴标题 */
	private String seriesAxisTitle = "";
	/** 项目轴标题 */
	private String categoryAxisTitle = "";
	/** 图表数据源定义 */
	private MetaChartDataSource dataSource = null;
	/** 是否显示值*/
	private Boolean showValue = true;
	/** 是否填满内部，仅雷达图使用*/
	private Boolean fill = false;
	/** 是否有显示动画*/
	private Boolean hasAnimation = false;
	/** 点击事件 */
	private MetaBaseScript onClick = null;
	/**图表模板**/
	private MetaChartTemplate chartTemplate = null;
	
	public MetaChart() {
		super();
	}
	
	/**
	 * 设置图表类型
	 * @param chartType 图表类型
	 */
	public void setChartType(Integer chartType) {
		this.chartType = chartType;
	}
	
	@Override
	public boolean receiveFocus() {
		return false;
	}
	
	/**
	 * 取得图表类型
	 * @return 图表类型
	 */
	public Integer getChartType() {
		return this.chartType;
	}
	
	/**
	 * 设置图表点击事件
	 * 
	 * @param onClick
	 *            按钮点击事件
	 */
	public void setOnClick(MetaBaseScript onClick) {
		this.onClick = onClick;
	}

	/**
	 * 获取图表点击事件
	 * 
	 * @return 点击事件
	 */
	public MetaBaseScript getOnClick() {
		return this.onClick;
	}
	
	
	public void setSourceType(Integer sourceType) {
		this.sourceType = sourceType;
	}
	
	public Integer getSourceType() {
		return this.sourceType;
	}
	
	public void setTitle(String title) {
		this.title = title;
	}
	
	public String getTitle() {
		return this.title;
	}
	
	public void setSeriesInRow(Boolean seriesInRow) {
		this.seriesInRow = seriesInRow;
	}
	
	public Boolean getSeriesInRow() {
		return this.seriesInRow;
	}
	
	public void setSeriesAxisTitle(String seriesAxisTitle) {
		this.seriesAxisTitle = seriesAxisTitle;
	}
	
	public String getSeriesAxisTitle() {
		return this.seriesAxisTitle;
	}
	
	public void setCategoryAxisTitle(String categoryAxisTitle) {
		this.categoryAxisTitle = categoryAxisTitle;
	}
	
	public String getCategoryAxisTitle() {
		return this.categoryAxisTitle;
	}
	
	public void setDataSource(MetaChartDataSource dataSource) {
		this.dataSource = dataSource;
	}
	
	public MetaChartDataSource getDataSource() {
		return this.dataSource;
	}
	
	public Boolean isShowValue() {
		return showValue;
	}

	public void setShowValue(Boolean showValues) {
		this.showValue = showValues;
	}

	public Boolean isFill() {
		return fill;
	}

	public void setFill(Boolean fill) {
		this.fill = fill;
	}

	public Boolean isHasAnimation() {
		return hasAnimation;
	}

	public void setHasAnimation(Boolean hasAnimation) {
		this.hasAnimation = hasAnimation;
	}
	
	public MetaChartTemplate getChartTemplate() {
		return chartTemplate;
	}
	
	public void setChartTemplate(MetaChartTemplate chartTemplate) {
		this.chartTemplate = chartTemplate;
	}
	
	

	@Override
	public int getControlType() {
		return ControlType.CHART;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		super.getChildMetaObjects(list);
		addAll(list, new Object[] {
				dataSource
		});
		if ( onClick != null ) {
			list.add(onClick);
		}
		if(chartTemplate != null) {
			list.add(chartTemplate);
		}
	}
	
	public static final String TAG_NAME = ControlType.STR_CHART;

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaChartDataSource.TAG_NAME.equals(tagName) ) {
			dataSource = new MetaChartDataSource();
			resultMetaObject = dataSource;
		} else if ( MetaConstants.Event_OnClick.equals(tagName) ){
			onClick = new MetaBaseScript(MetaConstants.Event_OnClick);
			resultMetaObject = onClick;
		} else if ( MetaChartTemplate.TAG_NAME.equals(tagName) ){
			chartTemplate = new MetaChartTemplate();
			resultMetaObject = chartTemplate;
		} else {
			resultMetaObject = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
		}
		return resultMetaObject;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaChart newObject = (MetaChart)super.clone();
		newObject.setOnClick(onClick == null ? null : (MetaBaseScript)onClick.clone());
		newObject.setChartType(chartType);
		newObject.setSourceType(sourceType);
		newObject.setTitle(title);
		newObject.setSeriesInRow(seriesInRow);
		newObject.setSeriesAxisTitle(seriesAxisTitle);
		newObject.setCategoryAxisTitle(categoryAxisTitle);
		newObject.setDataSource(dataSource == null ? null : (MetaChartDataSource)dataSource.clone());
		newObject.setShowValue(showValue);
		newObject.setFill(fill);
		newObject.setHasAnimation(hasAnimation);
		newObject.setChartTemplate(chartTemplate);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaChart();
	}

	@Override
	public AbstractMetaObject getProperties() {
		return null;
	}

}
