package com.bokesoft.yigo.meta.form;

import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.MetaComponentFactory;

/**
 * 弹出视图组件，通常是放在root属性为false的Block层中。
 * 这样不用特意使用visible=false去隐藏。
 * @author chenzs
 *
 */
public class MetaPopView extends MetaComponent {

	/** 配置文件中对应的节点的标签名称 */
	public static final String TAG_NAME = "PopView";

	/** 根组件 */
	private MetaComponent root = null;
	/** 关闭事件 */
	private MetaBaseScript onClose = null;
	/** 显示事件 */
	private MetaBaseScript onShow = null;
	/** 弹出动画*/
	private String popAnim = "";
	
	/**
	 * 设置弹出动画
	 * @param popAnim 弹出动画，参考{@link com.bokesoft.yigo.common.def.PopAnim}
	 */
	public void setPopAnim(String popAnim) {
		this.popAnim = popAnim;
	}
	
	/**
	 * 获取弹出动画 
	 * @return 弹出动画，参考{@link com.bokesoft.yigo.common.def.PopAnim}
	 */
	public String getPopAnim() {
		return popAnim;
	}

	/**
	 * 设置根组件
	 * 
	 * @param root
	 *            根组件
	 */
	public void setRoot(MetaComponent root) {
		this.root = root;
	}

	/**
	 * 取得根组件
	 * 
	 * @return 根组件
	 */
	public MetaComponent getRoot() {
		return this.root;
	}

	/**
	 * 设置关闭事件
	 * 
	 * @param onClose
	 *            关闭事件
	 */
	public void setOnClose(MetaBaseScript onClose) {
		this.onClose = onClose;
	}

	/**
	 * 取得关闭事件
	 * 
	 * @return 关闭事件
	 */
	public MetaBaseScript getOnClose() {
		return this.onClose;
	}

	/**
	 * 设置显示事件
	 * 
	 * @param onShow
	 *            显示事件
	 */
	public void setOnShow(MetaBaseScript onShow) {
		this.onShow = onShow;
	}

	/**
	 * 取得显示事件
	 * 
	 * @return 显示事件
	 */
	public MetaBaseScript getOnShow() {
		return this.onShow;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new AbstractMetaObject[] { root, onClose, onShow });
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
		super.doPostProcess(flag, callback);
		if(root != null){
			root.doPostProcess(flag, callback);
		}else{
			throw new MetaException(MetaException.NO_ROOT_CONTROL, 
					SimpleStringFormat.format(StringTable.getString(null, "", StringTable.NoRootControl), getKey()));
		}
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (MetaConstants.Event_OnClose.equals(tagName)) {
			this.onClose = new MetaBaseScript(MetaConstants.Event_OnClose);
			resultMetaObject = this.onClose;
		} else if (MetaConstants.Event_OnPostShow.equals(tagName)) {
			this.onShow = new MetaBaseScript(MetaConstants.Event_OnPostShow);
			resultMetaObject = this.onShow;
		} else {
			MetaComponent control = MetaComponentFactory.getInstance().newComponent(tagName);
			control.preProcessMetaObject(env, doc, node, flag, runType);
			this.addComponent(control);
			root = control;
			resultMetaObject = control;
		}
		return resultMetaObject;
	}

	@Override
	public int getControlType() {
		return ControlType.POPVIEW;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaPopView newObject = (MetaPopView) super.clone();
		newObject.setRoot(root == null ? null : (MetaComponent) root.clone());
		newObject.setOnClose(onClose == null? null : (MetaBaseScript)onClose.clone());
		newObject.setOnShow(onShow == null? null : (MetaBaseScript)onShow.clone());
		newObject.setPopAnim(popAnim);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaPopView();
	}

	@Override
	public AbstractMetaObject getProperties() {
		return null;
	}
}