package com.bokesoft.yigo.meta.form;

import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.def.HAlignment;
import com.bokesoft.yigo.common.def.ScrollType;
import com.bokesoft.yigo.common.def.VAlignment;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.theme.MetaThemeCollection;
import com.bokesoft.yigo.meta.form.component.view.MetaViewCollection;

public class MetaBody extends GenericNoKeyCollection<MetaComponent> implements IPropertyMerger<MetaBody>  {
	/** 水平对齐方式 */
	private Integer hAlign = HAlignment.LEFT;
	/** 垂直对齐方式 */
	private Integer vAlign = VAlignment.CENTER;
	/** 宽度 */
	private DefSize width = null;
	/** 高度 */
	private DefSize height = null;
	/** 弹出窗口宽度 */
	private DefSize popWidth = null;
	/** 弹出窗口高度 */
	private DefSize popHeight = null;
	/** 弹出窗口是否可调整大小*/
	private Boolean resizable = true;
	/** 水平滚动方式 */
	private Integer overflowX = ScrollType.Visible;
	/** 垂直滚动方式 */
	private Integer overflowY = ScrollType.Visible;
	/** 顶边距 */
	private DefSize topMargin = null;
	/** 顶边距 */
	private DefSize bottomMargin = null;
	/** 左边距 */
	private DefSize leftMargin = null;
	/** 右边距 */
	private DefSize rightMargin = null;
	/** 表单内容的提供者 */
	private String provider = "";
	/** 计算优化,面板不render,内部组件可见可用不计算,render再计算*/
	private Boolean lazyCompute = false;
	/** 视图集合 */
	private MetaViewCollection viewCollection = null;
	/** 主题集合 */
	private MetaThemeCollection themeCollection = null;
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new Object[] {
				viewCollection, themeCollection
		});
	}

	public static final String TAG_NAME = "Body";

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node,
			String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject child = null;
		if (tagName.equals(MetaBlock.TAG_NAME)) {
			child = new MetaBlock();
			child.preProcessMetaObject(env, doc, node, flag, runType);
			this.add((MetaComponent)child);
		} else if (tagName.equals(MetaHtmlSection.TAG_NAME)) {
			child = new MetaHtmlSection();
			child.preProcessMetaObject(env, doc, node, flag, runType);
			this.add((MetaComponent)child);
		} else if ( MetaViewCollection.TAG_NAME.equals(tagName) ) {
			this.viewCollection = new MetaViewCollection();
			child = viewCollection;
		} else if ( MetaThemeCollection.TAG_NAME.equals(tagName) ) {
			this.themeCollection = new MetaThemeCollection();
			child = themeCollection;
		}
		
		return child;
	}
	
	/**
	 * 设置视图集合
	 * @param viewCollection 视图集合
	 */
	public void setViewCollection(MetaViewCollection viewCollection) {
		this.viewCollection = viewCollection;
	}
	
	/**
	 * 取得视图集合
	 * @return 视图集合
	 */
	public MetaViewCollection getViewCollection() {
		return this.viewCollection;
	}
	
	/**
	 * 设置主题集合
	 * @param themeCollection 主题集合
	 */
	public void setThemeCollection(MetaThemeCollection themeCollection) {
		this.themeCollection = themeCollection;
	}
	
	/**
	 * 取得主题集合
	 * @return 主题集合
	 */
	public MetaThemeCollection getThemeCollection() {
		return this.themeCollection;
	}
	
	/**
	 * 设置组件本身的宽度
	 * 
	 * @param width
	 *            宽度
	 */
	public void setWidth(DefSize width) {
		this.width = width;
	}

	/**
	 * 获取宽度
	 * 
	 * @return 宽度
	 */
	public DefSize getWidth() {
		return this.width;
	}
	
	/**
	 * 设置高度
	 * @param height 高度
	 */
	public void setHeight(DefSize height) {
		this.height = height;
	}
	
	/**
	 * 取得高度
	 * @return 高度
	 */
	public DefSize getHeight() {
		return this.height;
	}
	
	/**
	 * 设置弹出窗口宽度
	 * @param popWidth 弹出窗口宽度
	 */
	public void setPopWidth(DefSize popWidth) {
		this.popWidth = popWidth;
	}
	
	/**
	 * 取得弹出窗口宽度
	 * @return 弹出窗口宽度
	 */
	public DefSize getPopWidth() {
		return this.popWidth;
	}
	
	/**
	 * 设置弹出窗口高度
	 * @param popHeight 弹出窗口高度
	 */
	public void setPopHeight(DefSize popHeight) {
		this.popHeight = popHeight;
	}
	
	/**
	 * 取得弹出窗口高度
	 * @return 弹出窗口高度
	 */
	public DefSize getPopHeight() {
		return this.popHeight;
	}
	
	/**
	 * 是否可大小可调整
	 * @return 大小可调整标志
	 */
	public Boolean isResizable() {
		return resizable;
	}

	/**
	 * 设置是否可大小可调整
	 * @param resizable 标志
	 */
	public void setResizable(Boolean resizable) {
		this.resizable = resizable;
	}
	
	/**
	 * 是否延迟计算可用可见
	 * @return 是否延迟
	 */
	public Boolean isLazyCompute() {
		return lazyCompute;
	}

	/**
	 * 设置是否延迟计算
	 * @param lazyCompute 是否延迟
	 */
	public void setLazyCompute(Boolean lazyCompute) {
		this.lazyCompute = lazyCompute;
	}

	/**
	 * 设置水平对齐方式
	 * @param hAlign 水平对齐方式
	 * @see com.bokesoft.yigo.common.def.HAlignment
	 */
	public void setHAlign(Integer hAlign) {
		this.hAlign = hAlign;
	}
	
	/**
	 * 取得水平对齐方式
	 * @return 水平对齐方式
	 * @see com.bokesoft.yigo.common.def.HAlignment
	 */
	public Integer getHAlign() {
		return this.hAlign;
	}
	
	/**
	 * 设置垂直对齐方式
	 * @param vAlign 垂直对齐方式
	 * @see com.bokesoft.yigo.common.def.VAlignment
	 */
	public void setVAlign(Integer vAlign) {
		this.vAlign = vAlign;
	}
	
	/**
	 * 取得垂直对齐方式
	 * @return 垂直对齐方式
	 */
	public Integer getVAlign() {
		return this.vAlign;
	}
	
	/**
	 * 设置水平滚动方式
	 * @param overflowX 水平滚动方式
	 */
	public void setOverflowX(Integer overflowX) {
		this.overflowX = overflowX;
	}
	
	/**
	 * 取得水平滚动方式
	 * @return 水平滚动方式
	 */
	public Integer getOverflowX() {
		return this.overflowX;
	}
	
	/**
	 * 设置垂直滚动方式
	 * @param overflowY 垂直滚动方式
	 */
	public void setOverflowY(Integer overflowY) {
		this.overflowY = overflowY;
	}
	
	/**
	 * 取得垂直滚动方式
	 * @return 垂直滚动方式
	 */
	public Integer getOverflowY() {
		return this.overflowY;
	}
	
	/**
	 * 设置顶边距
	 * @param topMargin 顶边距
	 */
	public void setTopMargin(DefSize topMargin) {
		this.topMargin = topMargin;
	}
	
	/**
	 * 取得顶边距
	 * @return 顶边距
	 */
	public DefSize getTopMargin() {
		return this.topMargin;
	}
	
	/**
	 * 设置底边距
	 * @param bottomMargin 底边距
	 */
	public void setBottomMargin(DefSize bottomMargin) {
		this.bottomMargin = bottomMargin;
	}
	
	/**
	 * 取得底边距
	 * @return 底边距
	 */
	public DefSize getBottomMargin() {
		return this.bottomMargin;
	}
	
	/**
	 * 设置左边距
	 * @param leftMargin 左边距
	 */
	public void setLeftMargin(DefSize leftMargin) {
		this.leftMargin = leftMargin;
	}
	
	/**
	 * 取得左边距
	 * @return 左边距
	 */
	public DefSize getLeftMargin() {
		return this.leftMargin;
	}
	
	/**
	 * 设置右边距
	 * @param rightMargin 右边距
	 */
	public void setRightMargin(DefSize rightMargin) {
		this.rightMargin = rightMargin;
	}
	
	/**
	 * 取得右边距
	 * @return 右边距
	 */
	public DefSize getRightMargin() {
		return this.rightMargin;
	}
	
	/**
	 * 设置表单内容提供者
	 * @param provider 提供者
	 */
	public void setProvider(String provider) {
		this.provider = provider;
	}
	
	/**
	 * 取得表单内容提供者
	 * @return 提供者
	 */
	public String getProvider() {
		return this.provider;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaBody newObject = (MetaBody)super.clone();
		newObject.setViewCollection(viewCollection == null ? null : (MetaViewCollection)viewCollection.clone());
		newObject.setThemeCollection(themeCollection == null ? null : (MetaThemeCollection)themeCollection.clone());
		newObject.setHAlign(hAlign);
		newObject.setVAlign(vAlign);
		newObject.setWidth(width);
		newObject.setHeight(height);
		newObject.setPopWidth(popWidth);
		newObject.setPopHeight(popHeight);
		newObject.setOverflowX(overflowX);
		newObject.setOverflowY(overflowY);
		newObject.setTopMargin(topMargin);
		newObject.setBottomMargin(bottomMargin);
		newObject.setLeftMargin(leftMargin);
		newObject.setRightMargin(rightMargin);
		newObject.setProvider(provider);
		newObject.setLazyCompute(lazyCompute);
		
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaBody();
	}
	
	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject,Boolean> callback) throws MetaException {
		super.doPostProcess(flag, callback);
		if ( this.themeCollection != null ) {
			this.themeCollection.doPostProcess(flag, callback);
		}
		if (viewCollection != null) {
			viewCollection.doPostProcess(flag, callback);
		}
	}

	@Override
	public void merge(MetaBody metaComponents) {
		if (this.hAlign == null) {
			this.hAlign = metaComponents.hAlign;
		}
		if (this.vAlign == null) {
			this.vAlign = metaComponents.vAlign;
		}
		if (this.width == null) {
			this.width = metaComponents.width;
		}
		if (this.height == null) {
			this.height = metaComponents.height;
		}
		if (this.popWidth == null) {
			this.popWidth = metaComponents.popWidth;
		}
		if (this.popHeight == null) {
			this.popHeight = metaComponents.popHeight;
		}
		if (this.overflowX == null) {
			this.overflowX = metaComponents.overflowX;
		}
		if (this.overflowY == null) {
			this.overflowY = metaComponents.overflowY;
		}
		if (this.topMargin == null) {
			this.topMargin = metaComponents.topMargin;
		}
		if (this.bottomMargin == null) {
			this.bottomMargin = metaComponents.bottomMargin;
		}
		if (this.leftMargin == null) {
			this.leftMargin = metaComponents.leftMargin;
		}
		if (this.rightMargin == null) {
			this.rightMargin = metaComponents.rightMargin;
		}
		if (this.provider == null) {
			this.provider = metaComponents.provider;

		}
		if (this.lazyCompute == null) {
			this.lazyCompute = metaComponents.lazyCompute;
		}
		if(this.resizable == null) {
            this.resizable = metaComponents.resizable;
        }




	}
}