package com.bokesoft.yigo.meta.flatcanvas.node;

import java.util.List;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yigo.meta.flatcanvas.convertor.IContentHandler;
import com.bokesoft.yigo.meta.flatcanvas.convertor.INode;

/**
 * 平面图中的区域集合
 * 
 * @author chenbinbin
 *
 */
public class MetaFCSectionCollection extends MetaFCCollection<MetaFCSection> {

	public static final String TAG_NAME = "SectionCollection";
	
	@Override
	public List<String> getPropItemKeys() {
		return null;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	@Override
	protected void loadChild(Element elem) {
		NodeList nodeList = elem.getChildNodes();
		for (int i=0; i < nodeList.getLength(); i++) {
			if (nodeList.item(i).getNodeType() == 1) {
				Element child = (Element)nodeList.item(i);
				MetaFCSection sectionModel = new MetaFCSection();
				sectionModel.loadFromElement(child);
				this.addItem(sectionModel);
			}
		}
	}
	
	public MetaFCSection getSection(String key) {
		if (StringUtil.isBlankOrNull(key)) {
			return null;
		}
		
		for (MetaFCSection section : this.values()) {
			if (key.equals(section.getKey())) {
				return section;
			}
			MetaFCSection childSection = section.getSection(key);
			if (childSection != null) {
				return childSection;
			}
		}
		return null;
	}

	@Override
	protected boolean isCollection() {
		return true;
	}

	@Override
	protected boolean saveChild(IContentHandler saveHandler, INode node) {
		boolean result = false;
		for(MetaFCSection section: this.values()) {
			result |= section.saveTo(saveHandler, node);
		}
		return result;
	}
}
