package com.bokesoft.yigo.meta.flatcanvas.node;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import org.w3c.dom.Element;

import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.flatcanvas.convertor.IContentHandler;
import com.bokesoft.yigo.meta.flatcanvas.convertor.INode;
import com.bokesoft.yigo.meta.flatcanvas.struct.FCAttrNames;

/**
 * 平面图面板 
 * 
 * @author chenbinbin
 *
 */
public class MetaFCBoard extends AbstractMetaFCObject {
	
	public static final String TAG_NAME = "Board";
	
	public static final List<String> ATTRS_BOARD = Arrays.asList(
			FCAttrNames.ATTR_width, FCAttrNames.ATTR_height);
	
	private MetaFCSectionCollection sectionCollection = new MetaFCSectionCollection();
	
	/**
	 * 设置平面图面板宽
	 * 
	 * @param width 宽度
	 */
	public void setWidth(int width) {
		set(FCAttrNames.ATTR_width, TypeConvertor.toString(width));
	}
	
	/**
	 * 设置平面图面板高
	 * 
	 * @param height 高度
	 */
	public void setHeight(int height) {
		this.set(FCAttrNames.ATTR_height, TypeConvertor.toString(height));
	}
	
	/**
	 * 获取平面图宽度
	 * 
	 * @return 平面图宽度
	 */
	public Integer getWidth() {
		return TypeConvertor.toInteger(get(FCAttrNames.ATTR_width));
	}
	
	/**
	 * 获取平面图高
	 * 
	 * @return 平面图高
	 */
	public Integer getHeight() {
		return TypeConvertor.toInteger(get(FCAttrNames.ATTR_height));
	}
	
	/**
	 * 获取指定子区域
	 * 
	 * @param key 标识
	 * @return 子区域
	 */
	public MetaFCSection getSection(String key) {
		return sectionCollection.getSection(key);
	}
	
	/**
	 * 获取平面图中的区域块集合
	 * 
	 * @return 平面图中的区域块集合
	 */
	public Collection<MetaFCSection> sections() {
		return sectionCollection.values();
	}
	
	/**
	 * 平面图面板中添加区域块
	 * 
	 * @param section 平面图区域
	 */
	public void addSection(MetaFCSection section) {
		sectionCollection.addItem(section);
	}
	
	/**
	 * 移除平面图面板中的区域块
	 * 
	 * @param section 平面图区域
	 */
	public void removeSection(MetaFCSection section) {
		sectionCollection.remove(section);
	}
	
	@Override
	public List<String> getPropItemKeys() {
		return ATTRS_BOARD;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	@Override
	protected void loadChild(Element elem) {
		Element child = (Element) elem.getElementsByTagName(MetaFCSectionCollection.TAG_NAME).item(0);
		sectionCollection.loadFromElement(child);
	}

	@Override
	protected boolean isCollection() {
		return false;
	}

	@Override
	protected boolean saveChild(IContentHandler saveHandler, INode node) {
		return sectionCollection.saveTo(saveHandler, node);
	}
}
