package com.bokesoft.yigo.meta.flatcanvas.convertor.xml;

import org.w3c.dom.Document;

import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.flatcanvas.convertor.IContentHandler;
import com.bokesoft.yigo.meta.flatcanvas.convertor.INode;

/**
 * 
 * 配置对象的xml格式转储
 * 
 * @author chenbinbin
 *
 */
public class XmlContentHandler implements IContentHandler {

	private Document document = null;

	private INode root = null;

	public XmlContentHandler() throws Exception {
		this(DomHelper.createDocument());
	}

	public XmlContentHandler(Document doc) {
		this.document = doc;
		root = new DomNode(doc);
	}

	@Override
	public INode createNode(String tagName, boolean isCollection) {
		return new DomNode(document.createElement(tagName));
	}

	@Override
	public INode getRoot() {
		return root;
	}

	@Override
	public String getContent() {
		return document.toString();
	}
}
