package com.bokesoft.yigo.meta.flatcanvas.convertor.xml;

import org.w3c.dom.Element;
import org.w3c.dom.Node;

import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.flatcanvas.convertor.INode;

/**
 * 配置节点对象的xml节点表述
 * 
 * @author chenbinbin
 *
 */
public class DomNode implements INode {
	
	private Node element = null;
	
	public DomNode(Node element) {
		this.element = element;
	}
	
	@Override
	public void setAttribute(String key, Object value) {
		((Element) element).setAttribute(key, TypeConvertor.toString(value));
	}

	@Override
	public void appendChild(INode node) {
		Element elem = (Element) node.getData();
		element.appendChild(elem);
	}

	@Override
	public Object getData() {
		return element;
	}

	@Override
	public String getTagName() {
		return ((Element) element).getTagName();
	}
}
