package com.bokesoft.yigo.meta.flatcanvas.common;

/**
 * 平面图中的点对象
 * 
 * @author chenbinbin
 *
 */
public class Point {

	/** 横坐标 */
    public int x = 0;
    /** 纵坐标 */
    public int y = 0;

    public Point() {
        this.x = 0;
        this.y = 0;
    }

    public Point(int x, int y) {
        this.x = x;
        this.y = y;
    }
    
    public Point(double x, double y) {
        this.x = (int) x;
        this.y = (int) y;
    }

    /**
     * 获取x坐标
     * 
     * @return 横向坐标
     */
    public int getX() {
        return x;
    }

    /**
     * 设置x坐标
     * 
     * @param x 横向坐标
     */
    public void setX(int x) {
        this.x = x;
    }

    /**
     * 获取y坐标
     * 
     * @return 纵坐标
     */
    public int getY() {
        return y;
    }

    /**
     * 设置y坐标
     * 
     * @param y 纵坐标
     */
    public void setY(int y) {
        this.y = y;
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 29 * hash + this.x;
        hash = 29 * hash + this.y;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final Point other = (Point) obj;
        if (this.x != other.x) {
            return false;
        }
        if (this.y != other.y) {
            return false;
        }
        return true;
    }

}
