package com.bokesoft.yigo.meta.exceltemplate;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.HAlignment;
import com.bokesoft.yigo.common.def.VAlignment;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaExcelDisplay extends AbstractMetaObject {
	/** 字体 */
	private MetaExcelFont font = null;
	/** 格式 */
	private MetaExcelFormat format = null;
	/** 对框 */
	private MetaExcelBorder border = null;
	/** 水平对齐方式 */
	private Integer hAlign = HAlignment.CENTER;
	/** 垂直对齐方式 */
	private Integer vAlign = VAlignment.CENTER;
	/** 背景色 */
	private String backColor = "";
	/** 前景色 */
	private String foreColor = "";
	/** 自动换行*/
	private Boolean wrapText = false;
	
	public MetaExcelDisplay() {
		super();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		this.addAll2(list, this.font, this.format, this.border);
	}

	public static final String TAG_NAME = "Display";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	/**
	 * 设置字体
	 * @param font 字体
	 */
	public void setFont(MetaExcelFont font) {
		this.font = font;
	}
	
	/**
	 * 取得字体
	 * @return 字体
	 */
	public MetaExcelFont getFont() {
		return this.font;
	}
	
	/**
	 * 取得字体，为null的时候创建一个空的
	 * @return 字体
	 */
	public MetaExcelFont ensureFont() {
		if ( this.font == null ) {
			this.font = new MetaExcelFont();
		}
		return this.font;
	}
	
	/**
	 * 设置格式
	 * @param format 格式
	 */
	public void setFormat(MetaExcelFormat format) {
		this.format = format;
	}
	
	/**
	 * 取得格式
	 * @return 格式
	 */
	public MetaExcelFormat getFormat() {
		return this.format;
	}
	
	/**
	 * 取得格式，为null的时候创建一个空的
	 * @return 格式
	 */
	public MetaExcelFormat ensureFormat(){
		if ( this.format == null ) {
			this.format = new MetaExcelFormat();
		}
		return this.format;
	}
	
	/**
	 * 设置边框
	 * @param border 边框
	 */
	public void setBorder(MetaExcelBorder border) {
		this.border = border;
	}
	
	/**
	 * 取得边框
	 * @return 边框
	 */
	public MetaExcelBorder getBorder() {
		return this.border;
	}
	
	/**
	 * 取得边框，如果不存在，则创建一个
	 * @return 边框
	 */
	public MetaExcelBorder ensureBorder() {
		if ( this.border == null ) {
			this.border = new MetaExcelBorder();
		}
		return this.border;
	}
	
	/**
	 * 设置水平对齐方式
	 * @param hAlign 水平对齐方式
	 */
	public void setHAlign(Integer hAlign) {
		this.hAlign = hAlign;
	}
	
	/**
	 * 取得水平对齐方式
	 * @return 水平对齐方式
	 */
	public Integer getHAlign() {
		return this.hAlign;
	}
	
	/**
	 * 设置垂直对齐方式
	 * @param vAlign 垂直对齐方式
	 */
	public void setVAlign(Integer vAlign) {
		this.vAlign = vAlign;
	}
	
	/**
	 * 取得垂直对齐方式
	 * @return 垂直对齐方式
	 */
	public Integer getVAlign() {
		return this.vAlign;
	}
	
	/**
	 * 取得背景色
	 * @return 背景色
	 */
	public String getBackColor() {
		return backColor;
	}

	/**
	 * 设置背景色
	 * @param backColor 背景色
	 */
	public void setBackColor(String backColor) {
		this.backColor = backColor;
	}

	/**
	 * 取得前景色
	 * @return 前景色
	 */
	public String getForeColor() {
		return foreColor;
	}

	/**
	 * 设置前景色
	 * @param foreColor 前景色
	 */
	public void setForeColor(String foreColor) {
		this.foreColor = foreColor;
	}


	public Boolean isWrapText() {
		return wrapText;
	}

	public void setWrapText(Boolean wrapText) {
		this.wrapText = wrapText;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaExcelFont.TAG_NAME.equals(tagName) ) {
			this.font = new MetaExcelFont();
			resultMetaObject = this.font;
		} else if ( MetaExcelFormat.TAG_NAME.equals(tagName) ) {
			this.format = new MetaExcelFormat();
			resultMetaObject = this.format;
		} else if ( MetaExcelBorder.TAG_NAME.equals(tagName) ) {
			this.border = new MetaExcelBorder();
			resultMetaObject = this.border;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaExcelDisplay newObject = (MetaExcelDisplay)newInstance();
		newObject.setFont(this.font == null ? null : (MetaExcelFont)this.font.clone());
		newObject.setFormat(this.format == null ? null : (MetaExcelFormat)this.format.clone());
		newObject.setBorder(this.border == null ? null : (MetaExcelBorder)this.border.clone());
		newObject.setHAlign(hAlign);
		newObject.setVAlign(vAlign);
		newObject.setBackColor(backColor);
		newObject.setForeColor(foreColor);
		
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaExcelDisplay();
	}
	
	public boolean isDefault(){
		return foreColor.isEmpty() &&
		backColor.isEmpty() &&
		hAlign == HAlignment.CENTER &&
		vAlign == VAlignment.CENTER &&
		!wrapText &&
		font == null  &&
		border == null &&
		format == null ;
	}
}
