package com.bokesoft.yigo.meta.enhance;

import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IElementMerge;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaExtMidFunction extends GenericKeyCollection<MetaMidFunction> implements IElementMerge<MetaExtMidFunction> {

	public static final String TAG_NAME = "ExtMidFunction";
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if(MetaMidFunction.TAG_NAME.equals(tagName)){
			MetaMidFunction midFunc = new MetaMidFunction();
			midFunc.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(midFunc);
			resultMetaObject = midFunc;
		} else {
			throw new MetaException(MetaException.NO_ACTION_DEFINED,
					"No MetaObject defined for " + tagName);
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaExtMidFunction();
	}

	@Override
	public MetaExtMidFunction toMerge(MetaExtMidFunction obj) {
		if (obj != null) {
			Iterator<MetaMidFunction> iterator = obj.iterator();
			while (iterator.hasNext()) {
				MetaMidFunction metaMidFunction = (MetaMidFunction) iterator.next();
				if (!containsKey(metaMidFunction.getKey())) {
					add(metaMidFunction);
				}
			}
		}
		return this;
	}

}
