package com.bokesoft.yigo.meta.domain;

import java.util.LinkedList;
import java.util.Set;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaDomainCollection extends GenericKeyCollection<MetaDomain> {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	/** 配置文件中对应片段的起始标签名称 */
	public static final String TAG_NAME = "DomainCollection";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		
		if (MetaDomain.TAG_NAME.equals(tagName)) {
			MetaDomain meta = new MetaDomain();
			meta.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(meta);
			resultMetaObject = meta;
		}
		
		return resultMetaObject;
	}

	public MetaDomain add(MetaDomain element) {
		check(element);
		return super.add(element);
	}
	
	private void check(MetaDomain element) {
		Set<String> keySet = elementMap.keySet();
		for(String s: keySet) {
			if(s.equalsIgnoreCase(element.getKey())) {
				throw new MetaException(MetaException.REPEAT_KEY_DEFINED,  SimpleStringFormat
						.format(StringTable.getString(null, "", StringTable.RepeatKeyDefined), element.getKey()));
			}
		}
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {

	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaDomainCollection();
	}

}

