package com.bokesoft.yigo.meta.domain;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.CaseType;
import com.bokesoft.yigo.common.def.RefControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.control.MetaDefaultItem;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaListBoxItemCollection;
import com.bokesoft.yigo.meta.intf.IMetaProject;

import java.util.LinkedList;

/**
 * 域对象
 * 域对象定义了一些和组件相关的属性，目前只做校验用不同步至组件
 * RefControlType 取值范围 None与可以绑定DataBinding的头字段组件
 * 如RefControlType不为none，需要与DataType相对应，即textEditor对应varchar numberEditor对应numeric
 * 字典 多选字典ItemKey需要设置RefControlType为Dict，下拉框 多选下拉下拉选项框需要设置RefControlType为Combobox CheckListBox
 * 文本框设置CaseType后，在数据库保存的时候会做大小写处理
 */
public class MetaDomain extends KeyPairMetaObject {

	private static final long serialVersionUID = 1L;

	/** 配置文件中对应片段的起始标签名称 */
	public static final String TAG_NAME = "Domain";
	/** 标识 */
	private String key = null;
	/** 名称 */
	private String caption = null;
    /** 组件类型 */
	private Integer refControlType = null;
    /** 列的数据类型 */
	private Integer dataType = null;
	/** 字符长度或二进制大小 */
	private Integer length = null;
	/** 数值精度 */
	private Integer precision = null;
	/** 小数位数 */
	private Integer scale = null;
	/** 大小写转换类型,-1表示未定义*/
	private Integer caseType = null;
    /** 下拉项来源,-1代表未定义*/
    private Integer sourceType = null;
    /** 当sourceType为ParaGroup时 的分组标志*/
    private String groupKey = null;
    /** 固定下拉项集合*/
    private MetaListBoxItemCollection items = null;
    /** 字典表示*/
    private String itemKey = null;
    /** 是否允许多选 */
    private Boolean isAllowMultiSelection = null;
    /** 动态字典的ItemKey范围项集合*/
    private MetaItemKeyCollection itemKeys = null;
    /** 动态字典的ItemKey范围项集合的来源公式*/
    private MetaBaseScript formulaItemKeys = null;

    /** 所在的工程*/
    private IMetaProject project = null;

    /** 系统自动生成标识 */
    private boolean autoGen = false;

    /** 数据库字段大小写是否敏感 */
    private Boolean caseSensitive= null;
    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public void setKey(String key) {
        this.key = key;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public void setRefControlType(Integer refControlType) {
        this.refControlType = refControlType;
    }

    public Integer getRefControlType() {
        return this.refControlType;
    }

    public void setDataType(Integer dataType) {
        this.dataType = dataType;
    }

    public Integer getDataType() {
        return this.dataType;
    }

    /**
     * 获得字符长度或二进制大小
     *
     * @return 字符长度或二进制大小
     */
    public Integer getLength() {
        return length;
    }

    /**
     * 设置 字符长度或二进制大小
     *
     * @param length
     *            字符长度或二进制大小
     */
    public void setLength(Integer length) {
        if (length != null && length == 1) {
            length = StringUtil.OneBlank_STRING_Length;
        }
        this.length = length;
    }

    /**
     * 获取数值精度
     *
     * @return 数值精度
     */
    public Integer getPrecision() {
        return precision;
    }

    /**
     * 设置数值精度
     *
     * @param precision
     *            数值精度
     */
    public void setPrecision(Integer precision) {
        this.precision = precision;
    }

    /**
     * 获取小数位数
     *
     * @return 小数位数
     */
    public Integer getScale() {
        return scale;
    }

    /**
     * 设置小数位数
     *
     * @param scale
     *            小数位数
     */
    public void setScale(Integer scale) {
        this.scale = scale;
    }

    public void setCase(Integer caseType) {
        this.caseType = caseType;
    }

    public Integer getCase() {
        return this.caseType;
    }

    /**
     * 取得来源类型
     * @return 来源类型
     */
    public Integer getSourceType(){
        return this.sourceType;
    }

    /**
     * 取得来源类型
     * @param type 来源类型
     */
    public void setSourceType(Integer type){
        this.sourceType = type;
    }

    /**
     * 取得组标识
     * @return 组标识
     */
    public String getGroupKey() {
        return groupKey;
    }

    /**
     * 设置组标识
     * @param groupKey 组标识
     */
    public void setGroupKey(String groupKey) {
        this.groupKey = groupKey;
    }

    /**
     * 根据序号获取下拉项
     *
     * @param index
     *            序号
     * @return 下拉项
     */
    public MetaDefaultItem getItem(int index) {
        return items.get(index);
    }

    /**
     * 设置下拉项集合
     * @param items 下拉项集合
     */
    public void setItems(MetaListBoxItemCollection items) {
        this.items = items;
    }

    /**
     * 取得下拉项集合
     * @return 下拉项集合
     */
    public MetaListBoxItemCollection getItems() {
        return items;
    }

    /**
     * 设置字典关联对象的标识
     *
     * @param key
     *            关联对象标识
     */
    public void setItemKey(String key) {
        this.itemKey = key;
    }

    /**
     * 获取字典关联对象的标识
     *
     * @return 关联对象标识
     */
    public String getItemKey() {
        return this.itemKey;
    }

    /**
     * 设置是否允许多选
     *
     * @param allow
     *            是否允许多选
     */
    public void setAllowMultiSelection(Boolean allow) {
        this.isAllowMultiSelection = allow;
    }

    /**
     * 获取是否允许多选
     *
     * @return 是否允许多选
     */
    public Boolean isAllowMultiSelection() {
        return this.isAllowMultiSelection;
    }

    public IMetaProject getProject() {
        return project;
    }

    public void setProject(IMetaProject project) {
        this.project = project;
    }

    /**
     * 系统生成标志
     *
     * @param autoGen
     *            标志
     */
    public void setAutoGen(boolean autoGen) {
        this.autoGen = autoGen;
    }

    @Override
    public boolean isAutoGen() {
        return this.autoGen;
    }

    public Boolean isCaseSensitive() {
        return caseSensitive;
    }

    public void setCaseSensitive(Boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        if (Boolean.TRUE.equals(caseSensitive)) {
            this.setCase(CaseType.NONE);
        }
    }

    public MetaItemKeyCollection getItemKeys() {
        return itemKeys;
    }

    public void setItemKeys(MetaItemKeyCollection itemKeys) {
        this.itemKeys = itemKeys;
    }

    public MetaBaseScript getFormulaItemKeys() {
        return formulaItemKeys;
    }

    public void setFormulaItemKeys(MetaBaseScript formulaItemKeys) {
        this.formulaItemKeys = formulaItemKeys;
    }

    @Override
    public void getChildMetaObjects(LinkedList<Object> list) {
        addAll(list, new AbstractMetaObject[] { items, itemKeys, formulaItemKeys});
    }

    @Override
    public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
                                                    int runType) throws MetaException {
        AbstractMetaObject resultMetaObject = null;
        if(refControlType == RefControlType.COMBOBOX || refControlType == RefControlType.CHECKLISTBOX || MetaDefaultItem.TAG_NAME.equals(tagName)) {
            if(items == null) {
                items = new MetaListBoxItemCollection();
            }
            resultMetaObject = items.createChildMetaObject(env, doc, node, tagName, flag, runType);
        } else if (MetaItemKeyCollection.TAG_NAME.equals(tagName)) {
            this.itemKeys = new MetaItemKeyCollection();
            resultMetaObject = this.itemKeys;
        } else if (MetaConstants.COMBOBOX_FORMULAITEMS.equals(tagName)) {
            this.formulaItemKeys = new MetaBaseScript(MetaConstants.COMBOBOX_FORMULAITEMS);
            resultMetaObject = this.formulaItemKeys;
        }
        return resultMetaObject;
    }

    @Override
    public AbstractMetaObject clone() {
        MetaDomain newObject = new MetaDomain();
        newObject.setKey(key);
        newObject.setCaption(caption);
        newObject.setRefControlType(refControlType);
        newObject.setDataType(dataType);
        newObject.setPrecision(precision);
        newObject.setScale(scale);
        newObject.setLength(length);
        newObject.setCase(caseType);
        newObject.setItems(items == null ? null : (MetaListBoxItemCollection)items.clone());
        newObject.setSourceType(sourceType);
        newObject.setGroupKey(groupKey);
        newObject.setItemKey(itemKey);
        newObject.setAllowMultiSelection(isAllowMultiSelection);
        newObject.setProject(project);
        newObject.setAutoGen(autoGen);
        newObject.setCaseSensitive(caseSensitive);
        newObject.setItemKeys(itemKeys == null ? null : (MetaItemKeyCollection)itemKeys.clone());
        newObject.setFormulaItemKeys(formulaItemKeys == null ? null : (MetaBaseScript) formulaItemKeys.clone());
        return newObject;
    }

    @Override
    public AbstractMetaObject newInstance() {
        return new MetaDomain();
    }

    /**
     * 后期处理,添加依赖
     */
    @Override
    public void doPostProcess(int flag, Callback<AbstractMetaObject,Boolean> callback) throws MetaException {
        super.doPostProcess(flag, callback);
    }
}
