package com.bokesoft.yigo.meta.diff.util;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;

public class DiffKeyUtil {
	/**
	 * 获取表单差异Key
	 * 
	 * @param metaKey
	 * @param metaType
	 * @return
	 */
	public static String getMetaDiffKey(String metaKey, String metaType) {
		StringBuilder sb = new StringBuilder();
		sb.append(metaType).append("@").append(metaKey);
		return sb.toString();
	}
	
	/**
	 * 根据配置节点层次结构生成差异节点Key
	 * @param meta
	 * @param parent
	 * @param grandParent
	 * @return
	 */
	public static String getDiffKey(String baseKey, AbstractMetaObject meta, AbstractMetaObject parent, AbstractMetaObject grandParent) {
		if (meta == null) return "";
		StringBuilder sb = new StringBuilder("");
		if(parent != null) sb.append(parent.getTagName());
		if (parent instanceof KeyPairMetaObject) {
			String parentKey = ((KeyPairMetaObject) parent).getKey();
			sb.append("@").append(parentKey);
		} else if(grandParent instanceof KeyPairMetaObject) {
			String parentKey = ((KeyPairMetaObject) grandParent).getKey();
			sb.append("@").append(parentKey);
		}
		if (sb.length() > 0) sb.append("|");
		if (!StringUtil.isBlankOrNull(baseKey)) {
			sb.append(baseKey);
		} else if (meta instanceof KeyPairMetaObject) {
			String key = ((KeyPairMetaObject) meta).getKey();
			sb.append(StringUtil.isBlankOrNull(key) ? meta.getTagName() : key);
		} else {
			sb.append(meta.getTagName());
		}
		return sb.toString();
	}
	
}
