package com.bokesoft.yigo.meta.dataobject;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import org.apache.commons.lang3.StringUtils;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.common.def.DataSplitType;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.common.def.MigrationAttributeDef;
import com.bokesoft.yigo.common.def.SortType;
import com.bokesoft.yigo.common.def.SystemField;
import com.bokesoft.yigo.common.def.TableMode;
import com.bokesoft.yigo.common.def.TableSourceType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollectionWithKey;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaStatement;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.IPropertyMerger;
import com.bokesoft.yigo.meta.schema.MetaIndex;
import com.bokesoft.yigo.meta.schema.MetaIndexCollection;
import com.bokesoft.yigo.meta.solution.MetaLangConfig;

/**
 * 数据表配置对象
 *
 * @author lishu
 * @since YES1.0
 */
public class MetaTable extends GenericKeyCollectionWithKey<MetaColumn> implements IPropertyMerger<MetaTable> {
	/**
	 *
	 */
	private static final long serialVersionUID = 1L;
	/** 表的标识 */
	private String key = "";
	/** 表的名称 */
	private String caption = "";
	/** 数据库表的标识 */
	private String dbTableName = "";
	/**
	 * <pre>
	 * 表的模式，取值范围为Head和Detail。
	 * 取值为Head表示在整个Object中仅有一条数据; 取值为Detail表示可以有0到多条数据。
	 * </pre>
	 */
	private Integer tableMode = TableMode.HEAD;
	/**
	 * 表的数据来源类型
	 *
	 * @see com.bokesoft.yigo.common.def.TableSourceType
	 */
	private Integer sourceType = TableSourceType.DATAOBJECT;
	/** 是否持久化。取值为True或False */
	private Boolean persist = true;
	/** 在SourceTable为Query的情况下提供查询语句 */
	private MetaStatement statement = null;
	/** 表达式 */
	private String formula = "";
	/** 实现类的名称 */
	private String impl = "";
	/** 父表标识 */
	private String parentKey = "";
	/** 是否隐藏属性，为true时，表示从数据结果中隐去该表的数据 */
	private Boolean hidden = false;
	/** 唯一主键标志 */
	private Boolean uniquePrimary = false;
	/** 过滤条件 */
	private MetaTableFilter filter = null;
	/** 定义的索引 */
	private MetaIndexCollection indexCollection = null;
	/** 值作为中间层使用的数据时，是否载入当前表的数据 */
	private Boolean loadInMidUse = true;
	/** 用户自定义索引前缀 */
	private String indexPrefix = "";
	/** 主键字段后缀(从配置中读取，如果没有定义则很据数据库表名生成) */
	private String primaryKey = "";
	/** 每次载表数据时强制刷新表的过滤条件 */
	private Boolean refreshFilter = false;
	/** 延迟加载 */
	private Boolean lazyLoad = false;

	// 以下属性并非来自配置文件，无需读写
	/** 索引的前缀(根据数据库表名生成) */
	private String tempIndexPrefix = null;

	// 预处理取出的系统字段
	/** OID列定义 */
	private MetaColumn OID = null;
	/** SOID列定义 */
	private MetaColumn SOID = null;
	/** POID列定义 */
	private MetaColumn POID = null;
	/** VERID列定义 */
	private MetaColumn VERID = null;
	/** DVERID列定义 */
	private MetaColumn DVERID = null;
	/** STATUS列定义 */
	private MetaColumn STATUS = null;
	/** INSTANCEID列定义 */
	private MetaColumn INSTANCEID = null;
	/** CLUSTERID列定义 */
	private MetaColumn CLUSTERID = null;
	/** MAPKEY列定义 */
	private MetaColumn MAPKEY = null;
	/** NO列定义 */
	private MetaColumn NO = null;
	/** BILLDATE列定义 */
	private MetaColumn BILLDATE = null;
	/** CREATETIME列定义 */
	private MetaColumn CREATETIME = null;
	/** LAYER列定义 */
	private MetaColumn LAYER = null;
	/** HIDDEN列定义 */
	private MetaColumn HIDDEN = null;
	/** SEQUENCE列定义 */
	private MetaColumn SEQUENCE = null;
	/** CREATOR列定义 */
	private MetaColumn CREATOR = null;
	/** MODIFIER列定义 */
	private MetaColumn MODIFIER = null;
	/** MODIFYTIME列定义 */
	private MetaColumn MODIFYTIME = null;
	/** CHECKER列定义 */
	private MetaColumn CHECKER = null;
	/** CHECKERTIME列定义 */
	private MetaColumn CHECKERTIME = null;
	/** SrcOID列定义 */
	private MetaColumn SrcOID = null;
	/** SrcSOID列定义 */
	private MetaColumn SrcSOID = null;
	/** MapCount列定义 */
	private MetaColumn MapCount = null;
	/** SVERID列定义 */
	private MetaColumn SVERID = null;
	/** SUBMITTER列定义 */
	private MetaColumn SUBMITTER = null;

	private MetaColumn CODE = null;

	private MetaColumn SrcLangOID = null;
	/**最后修改日期*/
	private MetaColumn LastModified = null;
	/**创建日期*/
	private MetaColumn CreateDate = null;
	/** 历史表名称 未定义则为key _HIS */
	private String hisTableName = "";


	// 预处理结束

	/** 表格所在的层数ID */
	private int levelID = -1;
	/** 过滤条件的参数列表 */
	private MetaParameterCollection parameterCollection = null;
	/** 其它来源集合 */
	private MetaTableSourceCollection sourceCollection = null;
	/** 排序字段 metaColumn 中定义sort属性的列集合 */
	private List<MetaColumn> sortColumns = null;
	/** 自定义排序子句 */
	private String orderBy = "";
	/** 自定义分组子句 */
	private String groupBy = "";
	/** 使用游标标志 */
	private boolean useCursor = false;
	/** 数据格式转换实现类，取值为实现com.bokesoft.yigo.mid.io.IResultSetConversion或com.bokesoft.yigo.mid.io.ITableConversion的类的全路径名 */
	private String convertor = "";

	/** 系统自动生成标识 */
	private boolean autoGen = false;

	/**
	 * 自动创建的翻译数据表
	 */
	private boolean T = false;
	/**
	 * 数据翻译表的后缀
	 */
	public static final String _T = "_T";

	public MetaTable() {
		super();
	}

	@Override
	public String getKey() {
		return key;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		this.addAll(list, new Object[] { this.filter, this.parameterCollection, this.sourceCollection, this.statement, this.indexCollection });
	}

	/** 表的标签名 */
	public static final String TAG_NAME = "Table";

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (MetaColumn.TAG_NAME.equals(tagName)) {
			resultMetaObject = new MetaColumn();
			resultMetaObject.preProcessMetaObject(env, doc, node, flag, runType);
			add((MetaColumn) resultMetaObject);
		} else if (MetaParameterCollection.TAG_NAME.equals(tagName)) {
			parameterCollection = new MetaParameterCollection();
			resultMetaObject = parameterCollection;
		} else if (MetaStatement.TAG_NAME.equals(tagName)) {
			this.statement = new MetaStatement();
			resultMetaObject = this.statement;
		} else if (MetaTableSourceCollection.TAG_NAME.equals(tagName)) {
			this.sourceCollection = new MetaTableSourceCollection();
			resultMetaObject = this.sourceCollection;
		} else if (MetaTableFilter.TAG_NAME.equals(tagName)) {
			this.filter = new MetaTableFilter();
			resultMetaObject = this.filter;
		} else if (MetaIndexCollection.TAG_NAME.equals(tagName)) {
			this.indexCollection = new MetaIndexCollection();
			resultMetaObject = this.indexCollection;
		}

		return resultMetaObject;
	}

	/**
	 * 获取表的名称
	 *
	 * @return 表名称
	 */
	public String getCaption() {
		return caption;
	}

	/**
	 * 获取表的模式
	 *
	 * @return 表的模式
	 */
	public Integer getTableMode() {
		return tableMode;
	}

	/**
	 * 获取表来源类型
	 *
	 * @return 来源类型
	 */
	public Integer getSourceType() {
		return sourceType;
	}

	/**
	 * 是否为头表
	 *
	 * @return 当前表是否为头表
	 */
	public boolean isHead() {
		return tableMode == TableMode.HEAD;
	}

	/**
	 * 获取是否持久化
	 *
	 * @return true或者false
	 */
	public Boolean isPersist() {
		return persist;
	}

	/**
	 * 设置表的标志
	 *
	 * @param key
	 *            标志
	 */
	public void setKey(String key) {
		this.key = key;
	}

	/**
	 * 设置表的名称
	 *
	 * @param caption
	 *            名称
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}

	/**
	 * 设置表的模式
	 *
	 * @param tableMode
	 *            表模式
	 */
	public void setTableMode(Integer tableMode) {
		this.tableMode = tableMode;
	}

	/**
	 * 设置表的来源类型
	 *
	 * @param sourceType
	 *            来源类型
	 */
	public void setSourceType(Integer sourceType) {
		this.sourceType = sourceType;
	}

	/**
	 * 设置是否持久化
	 *
	 * @param persist
	 *            是否持久化
	 */
	public void setPersist(Boolean persist) {
		this.persist = persist;
	}

	/**
	 * 设置数据表的标识
	 *
	 * @param dbTableName
	 *            数据库表标识
	 */
	public void setDBTableName(String dbTableName) {
		this.dbTableName = dbTableName;
	}

	/**
	 * 取得数据库表的标识
	 *
	 * @return 数据库表标识
	 */
	public String getDBTableName() {
		return dbTableName;
	}

	/**
	 * 取得绑定的数据表的标识
	 *
	 * @return 如果dbTableName不为空，返回dbTableName，否则返回key
	 */
	public String getBindingDBTableName() {
		return (dbTableName != null && !dbTableName.isEmpty()) ? dbTableName : key;
	}

	/**
	 * 获取历史表的表名
	 *
	 * @return 历史表的表名
	 */
	public String getHistoryTableName() {
		return (hisTableName != null && !hisTableName.isEmpty()) ? hisTableName: getBindingDBTableName() + "_HIS";
	}

	/**
	 * 取得字符串查询语句
	 *
	 * @return 字符串查询语句
	 */
	public String getStringStatement() {
		return this.statement != null ? this.statement.getContent() : null;
	}

	/**
	 * 设置表达式
	 *
	 * @param formula
	 *            表达式
	 */
	public void setFormula(String formula) {
		this.formula = formula;
	}

	/**
	 * 取得表达式
	 *
	 * @return 表达式
	 */
	public String getFormula() {
		return this.formula;
	}

	/**
	 * 设置实现类名称
	 *
	 * @param impl
	 *            实现类名称
	 */
	public void setImpl(String impl) {
		this.impl = impl;
	}

	/**
	 * 取得实现类名称
	 *
	 * @return 实现类名称
	 */
	public String getImpl() {
		return this.impl;
	}

	/**
	 * 取得查询语句
	 *
	 * @return 查询语句
	 */
	public MetaStatement getStatement() {
		return statement;
	}

	/**
	 * 设置查询语句
	 *
	 * @param statement
	 *            查询语句
	 */
	public void setStatement(MetaStatement statement) {
		this.statement = statement;
	}

	/**
	 * 设置过滤
	 *
	 * @return 过滤
	 */
	public MetaTableFilter getFilter() {
		return filter;
	}

	/**
	 * 设置过滤
	 *
	 * @param filter
	 *            过滤
	 */
	public void setFilter(MetaTableFilter filter) {
		this.filter = filter;
	}

	/**
	 * 返回排序列,metacolumn中定义sort属性的列集合
	 *
	 * @return 排序列
	 */
	public List<MetaColumn> getSortColumns() {
		if (this.sortColumns == null) {
			List<MetaColumn> tempList = new ArrayList<MetaColumn>();

			for (MetaColumn col : this) {
				if (col.getSort() != SortType.None) {
					tempList.add(col);
				}
			}
			this.sortColumns = tempList;
		}
		return this.sortColumns;
	}

	/**
	 * 取得父表标识
	 *
	 * @return 父表标识
	 */
	public String getParentKey() {
		return parentKey;
	}

	/**
	 * 设置父表标识
	 *
	 * @param parentKey
	 *            父表标识
	 */
	public void setParentKey(String parentKey) {
		this.parentKey = parentKey;
	}

	/**
	 * 设置隐藏属性
	 *
	 * @param hidden
	 *            隐藏标志
	 */
	public void setHidden(Boolean hidden) {
		this.hidden = hidden;
	}

	/**
	 * 取得隐藏属性
	 *
	 * @return 隐藏标志
	 */
	public Boolean isHidden() {
		return this.hidden;
	}

	/**
	 * 设置唯一业务主键标志
	 *
	 * @param uniquePrimary
	 *            标志
	 */
	public void setUniquePrimary(Boolean uniquePrimary) {
		this.uniquePrimary = uniquePrimary;
	}

	/**
	 * 取得唯一业务主键标志
	 *
	 * @return 标志
	 */
	public Boolean isUniquePrimary() {
		return this.uniquePrimary;
	}

	public Boolean isLoadInMidUse() {
		return loadInMidUse;
	}

	public void setLoadInMidUse(Boolean loadInMidUse) {
		this.loadInMidUse = loadInMidUse;
	}


	/**
	 * 取得是否延迟加载
	 *
	 * @return 延迟标志
	 */
	public Boolean isLazyLoad() {
		return lazyLoad;
	}

	/**
	 * 设置延迟加载
	 *
	 * @param lazyLoad 是否延迟加载
	 */
	public void setLazyLoad(Boolean lazyLoad) {
		this.lazyLoad = lazyLoad;
	}

	/**
	 * 设置来源集合
	 *
	 * @param sourceCollection
	 *            来源集合
	 */
	public void setSourceCollection(MetaTableSourceCollection sourceCollection) {
		this.sourceCollection = sourceCollection;
	}

	/**
	 * 取得来源集合
	 *
	 * @return 来源集合
	 */
	public MetaTableSourceCollection getSourceCollection() {
		return this.sourceCollection;
	}

	public MetaIndexCollection getIndexCollection() {
		return indexCollection;
	}

	public void setIndexCollection(MetaIndexCollection indexCollection) {
		this.indexCollection = indexCollection;
	}

	/**
	 * 取得OID列
	 *
	 * @return 如果存在OID的列，返回该列，否则返回null
	 */
	public MetaColumn getOIDColumn() {
		if( OID != null ) {
			return OID;
		}
		return this.get(SystemField.OID_SYS_KEY);
	}

	/**
	 * 取得SOID列
	 *
	 * @return 如果存在SOID的列，返回该列，否则返回null
	 */
	public MetaColumn getSOIDColumn() {
		return SOID;
	}

	/**
	 * 取得POID列
	 *
	 * @return 如果存在POID的列，返回该列，否则返回null
	 */
	public MetaColumn getPOIDColumn() {
		return POID;
	}

	/**
	 * 取得VERID列
	 *
	 * @return 如果存在VERID的列，返回该列，否则返回null
	 */
	public MetaColumn getVERIDColumn() {
		return VERID;
	}

	/**
	 * 取得DVERID列
	 *
	 * @return 如果存在DVERID的列，返回该列，否则返回null
	 */
	public MetaColumn getDVERIDColumn() {
		return DVERID;
	}

	/**
	 * 取得STATUS列
	 *
	 * @return 如果存在STATUS的列，返回该列，否则返回null
	 */
	public MetaColumn getSTATUSColumn() {
		return this.STATUS;
	}

	/**
	 * 取得INSTANCEID列
	 *
	 * @return 如果存在INSTANCEID的列，返回该列，否则返回null
	 */
	public MetaColumn getINSTANCEIDColumn() {
		return this.INSTANCEID;
	}

	/**
	 * 取得CLUSTERID列
	 *
	 * @return 如果存在CLUSTERID的列，返回该列，否则返回null
	 */
	public MetaColumn getCLUSTERIDColumn() {
		return this.CLUSTERID;
	}

	/**
	 * 取得MAPKEY列
	 *
	 * @return 如果存在MAPKEY的列，返回该列，否则返回null
	 */
	public MetaColumn getMAPKEYColumn() {
		return this.MAPKEY;
	}

	/**
	 * 取得单据编号列
	 *
	 * @return 如果存在NO的列，返回该列，否则返回null
	 */
	public MetaColumn getNOColumn() {
		return NO;
	}

	/**
	 * 取得单据日期
	 *
	 * @return 列定义
	 */
	public MetaColumn getBILLDATEColumn() {
		return BILLDATE;
	}

	/**
	 * 取得单据时间列
	 *
	 * @return 如果存在CREATETIME的列，返回该列，否则返回null
	 */
	public MetaColumn getCREATETIMEColumn() {
		return CREATETIME;
	}

	/**
	 * 取得层次列
	 *
	 * @return 如果存在LAYER的列，返回该列，否则返回null
	 */
	public MetaColumn getLayerColumn() {
		return this.LAYER;
	}

	/**
	 * 取得隐藏标志列
	 *
	 * @return 如果存在HIDDEN的列，返回该列，否则返回null
	 */
	public MetaColumn getHiddenColumn() {
		return this.HIDDEN;
	}

	public MetaColumn getSequenceColumn() {
		return SEQUENCE;
	}

	public MetaColumn getCreatorColumn() {
		return CREATOR;
	}

	public MetaColumn getModifierColumn() {
		return MODIFIER;
	}

	public MetaColumn getModifytimeColumn() {
		return MODIFYTIME;
	}

	public MetaColumn getCHECKER() {
		return CHECKER;
	}

	public MetaColumn getCHECKERTIME() {
		return CHECKERTIME;
	}

	public String getOrderBy() {
		return orderBy;
	}

	public void setOrderBy(String orderBy) {
		this.orderBy = orderBy;
	}

	public MetaColumn getSrcOIDColumn() {
		return SrcOID;
	}

	public MetaColumn getSrcSOIDColumn() {
		return SrcSOID;
	}

	public String getGroupBy() {
		return groupBy;
	}

	public void setGroupBy(String groupBy) {
		this.groupBy = groupBy;
	}

	public String getPrimaryKey() {
		return primaryKey;
	}

	public void setPrimaryKey(String primaryKey) {
		this.primaryKey = primaryKey;
	}

	public MetaColumn getLastModifiedColumn() {
		return LastModified;
	}
	
	/**
	 * 设置使用游标标志
	 *
	 * @param useCursor
	 *            标志
	 */
	public void setUseCursor(boolean useCursor) {
		this.useCursor = useCursor;
	}

	/**
	 * 取得使用游标标志
	 *
	 * @return 标志
	 */
	public boolean isUseCursor() {
		return this.useCursor;
	}

	/**
	 * 设置刷新过滤条件标志
	 *
	 * @param refreshFilter
	 *            标志
	 */
	public void setRefreshFilter(Boolean refreshFilter) {
		this.refreshFilter = refreshFilter;
	}

	/**
	 * 取得刷新过滤条件标志
	 *
	 * @return 标志
	 */
	public Boolean isRefreshFilter() {
		return this.refreshFilter;
	}

	/**
	 * 设置格式转换器
	 * @param convertor 格式转换器
	 */
	public void setConvertor(String convertor) {
		this.convertor = convertor;
	}

	/**
	 * 取得格式转换器
	 * @return 格式转换器
	 */
	public String getConvertor() {
		return this.convertor;
	}

	/**
	 * 系统生成标志
	 *
	 * @param autoGen
	 *            标志
	 */
	public void setAutoGen(boolean autoGen) {
		this.autoGen = autoGen;
	}

	@Override
	public boolean isAutoGen() {
		return this.autoGen;
	}

	public boolean isT() {
		return T;
	}

	public void setT(boolean t) {
		this.T = t;
	}

	private void reset() {
		if( this.OID != null ) {
			this.OID.setSystemControlField(false);
			this.OID = null;
		}
		if( this.SOID != null ) {
			this.SOID.setSystemControlField(false);
			this.SOID = null;
		}
		if( this.POID != null ) {
			this.POID.setSystemControlField(false);
			this.POID = null;
		}
		if( this.VERID != null ) {
			this.VERID.setSystemControlField(false);
			this.VERID = null;
		}
		if( this.DVERID != null ) {
			this.DVERID.setSystemControlField(false);
			this.DVERID = null;
		}
		if( this.MAPKEY != null ) {
			this.MAPKEY.setSystemControlField(false);
			this.MAPKEY = null;
		}
		if( this.NO != null ) {
			this.NO.setSystemControlField(false);
			this.NO = null;
		}

		this.STATUS = null;
		this.INSTANCEID = null;
		this.CLUSTERID = null;
		this.CREATETIME = null;
		this.BILLDATE = null;
		this.LAYER = null;
		this.HIDDEN = null;
		this.SEQUENCE = null;
		this.CREATOR = null;
		this.MODIFIER = null;
		this.MODIFYTIME = null;
		this.SrcOID = null;
		this.SrcSOID = null;
		this.MapCount = null;
		this.CHECKER = null;
		this.CHECKERTIME = null;
		this.SVERID = null;
		this.SUBMITTER = null;
		this.CODE = null;
		this.SrcLangOID = null;
		this.LastModified = null;
		this.CreateDate = null;
	}

	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
		reset();
		LinkedList<MetaColumn> autoGenColumnList = new LinkedList<MetaColumn>();

		this.forEach(metaColumn ->{
			String key = metaColumn.getKey();
			if (SystemField.OID_SYS_KEY.equalsIgnoreCase(key)) {
				this.OID = metaColumn;
				metaColumn.setSystemControlField(true);
			} else if (SystemField.SOID_SYS_KEY.equalsIgnoreCase(key)) {
				this.SOID = metaColumn;
				metaColumn.setSystemControlField(true);
			} else if (SystemField.POID_SYS_KEY.equalsIgnoreCase(key)) {
				this.POID = metaColumn;
				metaColumn.setSystemControlField(true);
			} else if (SystemField.VERID_SYS_KEY.equalsIgnoreCase(key)) {
				this.VERID = metaColumn;
				metaColumn.setSystemControlField(true);
			} else if (SystemField.DVERID_SYS_KEY.equalsIgnoreCase(key)) {
				this.DVERID = metaColumn;
				metaColumn.setSystemControlField(true);
			} else if (SystemField.STATUS_SYS_KEY.equalsIgnoreCase(key)) {
				this.STATUS = metaColumn;
			} else if (SystemField.INSTANCE_ID_SYS_KEY.equalsIgnoreCase(key)) {
				this.INSTANCEID = metaColumn;
			} else if (SystemField.CLUSTERID_SYS_KEY.equalsIgnoreCase(key)) {
				this.CLUSTERID = metaColumn;
			} else if (SystemField.MAPKEY_SYS_KEY.equalsIgnoreCase(key)) {
				this.MAPKEY = metaColumn;
				metaColumn.setSystemControlField(true);
			} else if (SystemField.NO_SYS_KEY.equalsIgnoreCase(key)) {
				this.NO = metaColumn;
				metaColumn.setSystemControlField(true);
			} else if (SystemField.CREATE_TIME_SYS_KEY.equalsIgnoreCase(key)) {
				this.CREATETIME = metaColumn;
			} else if (SystemField.BILLDATE_SYS_KEY.equalsIgnoreCase(key)) {
				this.BILLDATE = metaColumn;
			} else if (SystemField.LAYER_SYS_KEY.equalsIgnoreCase(key)) {
				this.LAYER = metaColumn;
			} else if (SystemField.HIDDEN_SYS_KEY.equalsIgnoreCase(key)) {
				this.HIDDEN = metaColumn;
			} else if (SystemField.SEQUENCE_SYS_KEY.equalsIgnoreCase(key)) {
				this.SEQUENCE = metaColumn;
			} else if (SystemField.CREATOR_SYS_KEY.equalsIgnoreCase(key)) {
				this.CREATOR = metaColumn;
			} else if (SystemField.MODIFIER_SYS_KEY.equalsIgnoreCase(key)) {
				this.MODIFIER = metaColumn;
			} else if (SystemField.MODIFY_TIME_SYS_KEY.equalsIgnoreCase(key)) {
				this.MODIFYTIME = metaColumn;
			} else if (SystemField.SRCOID_SYS_KEY.equalsIgnoreCase(key)) {
				this.SrcOID = metaColumn;
			} else if (SystemField.SRCSOID_SYS_KEY.equalsIgnoreCase(key)) {
				this.SrcSOID = metaColumn;
			} else if (SystemField.MAPCOUNT_SYS_KEY.equalsIgnoreCase(key)) {
				this.MapCount = metaColumn;
			} else if (SystemField.CHECKER_SYS_KEY.equalsIgnoreCase(key)) {
				this.CHECKER = metaColumn;
			} else if (SystemField.CHECKERT_TIME_SYS_KEY.equalsIgnoreCase(key)) {
				this.CHECKERTIME = metaColumn;
			} else if (SystemField.SVERID_SYS_KEY.equalsIgnoreCase(key)) {
				this.SVERID = metaColumn;
			} else if (SystemField.SUBMITTER_FIELD_KEY.equalsIgnoreCase(key)) {
				this.SUBMITTER = metaColumn;
			} else if (SystemField.CODE_DICT_KEY.equalsIgnoreCase(key)) {
				this.CODE = metaColumn;
			} else if (SystemField.SrcLangOID_SYS_KEY.equalsIgnoreCase(key)) {
				this.SrcLangOID = metaColumn;
			} else if (SystemField.LASTMODIFIED_SYS_KEY.equalsIgnoreCase(key)) {
				this.LastModified = metaColumn;
			} else if(SystemField.CREATE_DATE_SYS_KEY.equalsIgnoreCase(key)){
				this.CreateDate = metaColumn;
			}

			// 需要访问控制的字段，默认生成一个Key+"_CF"的32位整型字段
			if (metaColumn.isAccessControl()) {
				MetaColumn ctrlColumn = new MetaColumn();
				ctrlColumn.setKey(metaColumn.getKey() + "_CF");
				ctrlColumn.setDataType(DataType.INT);
				ctrlColumn.setDefaultValue("0");
				ctrlColumn.setPersist(true);
				autoGenColumnList.add(ctrlColumn);
			}

			if (metaColumn.getSplitType() == DataSplitType.Period) {
				String beginColumn = metaColumn.getKey() + MigrationAttributeDef.BEGIN_BALANCE_POSTFIX;
				String endColumn = metaColumn.getKey() + MigrationAttributeDef.END_BALANCE_POSTFIX;
				// 添加期初字段
				MetaColumn ctrlColumn = new MetaColumn();
				ctrlColumn.setKey(beginColumn);
				ctrlColumn.setCaption(metaColumn.getCaption() + "_期初");
				ctrlColumn.setDataType(metaColumn.getDataType());
				ctrlColumn.setDBColumnName(metaColumn.getBindingDBColumnName() + MigrationAttributeDef.BEGIN_BALANCE_POSTFIX);
				ctrlColumn.setPrecision(metaColumn.getPrecision());
				ctrlColumn.setScale(metaColumn.getScale());
				ctrlColumn.setLength(metaColumn.getLength());
				ctrlColumn.setAutoGen(true);
				ctrlColumn.setDataElementKey(metaColumn.getDataElementKey());
				ctrlColumn.setDataElement(metaColumn.getDataElement());
				ctrlColumn.setRefCol(metaColumn.getRefCol());
				autoGenColumnList.add(ctrlColumn);

				// 添加期末字段
				ctrlColumn = new MetaColumn();
				ctrlColumn.setKey(endColumn);
				ctrlColumn.setCaption(metaColumn.getCaption() + "_期末");
				ctrlColumn.setDataType(metaColumn.getDataType());
				ctrlColumn.setDBColumnName(metaColumn.getBindingDBColumnName() + MigrationAttributeDef.END_BALANCE_POSTFIX);
				ctrlColumn.setPrecision(metaColumn.getPrecision());
				ctrlColumn.setScale(metaColumn.getScale());
				ctrlColumn.setLength(metaColumn.getLength());
				ctrlColumn.setAutoGen(true);
				ctrlColumn.setDataElementKey(metaColumn.getDataElementKey());
				ctrlColumn.setDataElement(metaColumn.getDataElement());
				ctrlColumn.setRefCol(metaColumn.getRefCol());
				autoGenColumnList.add(ctrlColumn);
			}
			// Code字段和Name字段默认值为空字符串
			String codeColumnKey = metaColumn.getCodeColumnKey();
			MetaColumn codeColumn = StringUtils.isBlank(codeColumnKey) ? null : this.get(codeColumnKey);
			if (codeColumn != null && StringUtils.isBlank(codeColumn.getDefaultValue())) {
				codeColumn.setDefaultValue("");
			}
		});

		// 将自动生成的列加入到列集合
		Iterator<MetaColumn> itAutoGen = autoGenColumnList.iterator();
		MetaColumn ctrlColumn = null;
		while (itAutoGen.hasNext()) {
			ctrlColumn = itAutoGen.next();
			if(!containsKey(ctrlColumn.getKey())){
				this.add(ctrlColumn);
			}
		}

		// 再次循环
		this.forEach(metaColumn ->{
			metaColumn.doPostProcess(flag, callback);
		});

		if(callback != null){
			try {
				callback.call(this);
			} catch (Throwable e) {
				e.printStackTrace();
			}
		}
	}

	@Override
	public AbstractMetaObject clone() {
		MetaTable newObject = (MetaTable) super.clone();
		newObject.setKey(key);
		newObject.setCaption(caption);
		newObject.setDBTableName(dbTableName);
		newObject.setTableMode(tableMode);
		newObject.setSourceType(sourceType);
		newObject.setPersist(persist);
		newObject.setStatement(statement);
		newObject.setFilter(filter != null ? (MetaTableFilter) filter.clone() : null);
		newObject.setStatement(statement == null ? null : (MetaStatement) statement.clone());
		newObject.setParentKey(parentKey);
		newObject.setHidden(hidden);
		newObject.setUniquePrimary(uniquePrimary);
		newObject.setRefreshFilter(refreshFilter);
		newObject.setHisTableName(hisTableName);

		newObject.setParameterCollection(parameterCollection == null ? null : (MetaParameterCollection) parameterCollection.clone());
		newObject.setSourceCollection(sourceCollection == null ? null : (MetaTableSourceCollection) sourceCollection.clone());

		newObject.setOrderBy(orderBy);
		newObject.setGroupBy(groupBy);
		newObject.setConvertor(convertor);
		newObject.setFormula(formula);
		newObject.setImpl(impl);
		newObject.setLoadInMidUse(loadInMidUse);
		newObject.setLazyLoad(lazyLoad);
		newObject.setIndexPrefix(indexPrefix);
		newObject.setPrimaryKey(primaryKey);
		newObject.setUseCursor(useCursor);
		newObject.setT(T);

		// try {
		// newObject.doPostProcess(0, null);
		// } catch (MetaException e) {
		// e.printStackTrace();
		// }
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaTable();
	}

	public void setIndexPrefix(String indexPrefix) {
		this.indexPrefix = indexPrefix;
	}

	public String getIndexPrefix() {
		return indexPrefix;
	}

	public String getIndexPrefix4Create() {
		if (indexPrefix == null || indexPrefix.isEmpty()) {
			if (tempIndexPrefix == null) {
				String tableKey = getBindingDBTableName();
				int length = tableKey.length();
				tempIndexPrefix = "I_" + (length > 15 ? tableKey.substring(length - 15) : tableKey);
			}
			return tempIndexPrefix;
		}
		return indexPrefix;
	}

	public String getIndexPrefix2() {
		if (indexPrefix == null || indexPrefix.isEmpty()) {
			if (tempIndexPrefix == null) {
				String tableKey = getBindingDBTableName();
				Double length = new Double(tableKey.length());
				if (length <= 17)
					tempIndexPrefix = "I_" + tableKey;
				else {
					StringBuffer sb = new StringBuffer("I_");
					sb.append(tableKey.charAt(0));
					sb.append(tableKey.charAt(tableKey.length() - 1));
					for (int spiltCount = 2; spiltCount < 7; spiltCount++) {
						getSpiltInfo(tableKey, length, spiltCount, sb);
						tempIndexPrefix = sb.toString();
					}
				}
			}
			return tempIndexPrefix;
		}
		return indexPrefix;
	}

	private void getSpiltInfo(String s, Double length, int spiltCount, StringBuffer sb) {
		for (int i = 1; i < spiltCount; i++) {
			Double index = length / spiltCount * i;
			sb.append(s.charAt(index.intValue()));
		}
	}

	public int getLevelID() {
		return levelID;
	}

	public void setLevelID(int levelID) {
		this.levelID = levelID;
	}

	public MetaParameterCollection getParameterCollection() {
		return parameterCollection;
	}

	public void setParameterCollection(MetaParameterCollection parameterCollection) {
		this.parameterCollection = parameterCollection;
	}

	public MetaColumn getMapCount() {
		return this.MapCount;
	}

	public void setMapCount(MetaColumn mapCount) {
		this.MapCount = mapCount;
	}

	public MetaColumn getSVERID() {
		return SVERID;
	}

	public void setSVERID(MetaColumn sVERID) {
		SVERID = sVERID;
	}

	public MetaColumn getSUBMITTER() {
		return SUBMITTER;
	}

	public void setSUBMITTER(MetaColumn sUBMITTER) {
		SUBMITTER = sUBMITTER;
	}

	public MetaColumn getCODE() {
		return CODE;
	}

	public void setCODE(MetaColumn CODE) {
		this.CODE = CODE;
	}

	public MetaColumn getSrcLangOID() {
		return SrcLangOID;
	}

	public void setSrcLangOID(MetaColumn SrcLangOID) {
		this.SrcLangOID = SrcLangOID;
	}
	/**
	 * 获取历史表名称 
	 * @return 历史表名称
	 */
	public String getHisTableName() {
		return hisTableName;
	}

	/**
	 * 设置历史表名称 
	 * @param hisTableName 历史表名称
	 */
	public void setHisTableName(String hisTableName) {
		this.hisTableName = hisTableName;
	}

	public MetaColumn getLastModified() {
		return this.LastModified;
	}
	
	public void setLastModified(MetaColumn lastModified) {
		this.LastModified = lastModified;
	}

	public MetaColumn getCreateDate() { return this.CreateDate; }

	public void setCreateDate(MetaColumn createDate){ this.CreateDate = createDate; }
	/**
	 * 根据多语种配置，自动添加多语种列
	 * @param metaFactory 配置工厂
	 * @throws Throwable 配置处理异常
	 */
	public void initI18nColumn(IMetaFactory metaFactory) throws Throwable {
		if(!metaFactory.getSolution().isEnableMultiLang()){
			return;
		}

		MetaLangConfig langConfig = metaFactory.getSolution().getLangConfig();
		LinkedList<MetaColumn> autoGenColumnList = new LinkedList<MetaColumn>();

		Iterator<MetaColumn> it = this.iterator();
		MetaColumn metaColumn = null;

//		while (it.hasNext()) {
//			metaColumn = it.next();
//			if(metaColumn.isSupportI18n()){
//				if(langConfig != null){
//					for(MetaLang lang : langConfig){
//						MetaColumn clone = (MetaColumn)metaColumn.clone();
//						clone.setKey(metaColumn.getKey() + "_" + lang.getKey());
//						clone.setDBColumnName(metaColumn.getBindingDBColumnName() + "_" + lang.getSuffix());
//						clone.setSupportI18n(false);
//						autoGenColumnList.add(clone);
//					}
//				}
//			}
//		}

		// 将自动生成的列加入到列集合
		Iterator<MetaColumn> itAutoGen = autoGenColumnList.iterator();
		MetaColumn ctrlColumn = null;
		while (itAutoGen.hasNext()) {
			ctrlColumn = itAutoGen.next();
			this.add(ctrlColumn);
		}
		
	}

	/**
	 * 合并metaTable
	 * @param parentMetaTable
	 */
	public void merge(MetaTable parentMetaTable) {
		Iterator<MetaColumn> metaColumns = parentMetaTable.iterator();
		if (parentMetaTable.statement != null) {
			if(this.statement!=null){
				parentMetaTable.statement.setType(this.statement.getType());
				parentMetaTable.statement.setDBType(this.statement.getDBType());
				parentMetaTable.statement.setDynamic(this.statement.isDynamic());
			}
			this.statement = parentMetaTable.statement;
		}

		if (parentMetaTable.orderBy != null) {
			this.orderBy = parentMetaTable.orderBy;
		}
		while (metaColumns.hasNext()) {
			MetaColumn metaColumn = metaColumns.next();
			if (!this.containsKey(metaColumn.getKey())) {
				this.add((MetaColumn) metaColumn.clone());
			}
		}
		if (parentMetaTable.indexCollection != null && !parentMetaTable.indexCollection.isEmpty()) {
			if (this.indexCollection == null || this.indexCollection.isEmpty()) {
				this.indexCollection = parentMetaTable.indexCollection;
			} else {
				for (MetaIndex metaIndex : parentMetaTable.indexCollection) {
					if (this.indexCollection.containsKey(metaIndex.getKey())) {
						this.indexCollection.get(metaIndex.getKey()).merge(metaIndex);
					} else {
						this.indexCollection.add(metaIndex);
					}

				}
			}

		}

	}
}
