package com.bokesoft.yigo.meta.dataobject;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaRelation extends GenericNoKeyCollection<MetaLayer> {
	
	/**
	 * 关系表的名称
	 */
	private String caption = "";
	
	/**
	 * 关系表的描述
	 */
	private String description = "";
	
	
	/**
	 * 获取关系表的名称
	 * 
	 * @return 名称
	 */
	public String getCaption() {
		return caption;
	}
	
	/**
	 * 获取关系表的描述
	 * 
	 * @return 描述
	 */
	public String getDescription() {
		return description;
	}
	
	
	/**
	 * 设置关系表的名称
	 * 
	 * @param caption
	 *            名称
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}
	
	/**
	 * 设置关系表的描述
	 * 
	 * @param description
	 *            描述
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		
	}
	
	/**
	 * 根据itemKey 获取当前metaLayer
	 * @param itemKey 字典标识
	 * @return 如果存在itemKey的层次则返回层次对象对象，否则返回null
	 */
	public MetaLayer getMetaLayer(String itemKey){
		MetaLayer layer = null;
		for(int i = 0 ; i < this.size() ; i ++){
			layer = this.get(i);
			if(layer.getItemKey().equalsIgnoreCase(itemKey)){
				return layer;
			}
		}
		return null;
	}
	
	/**
	 * 是否是最后一层
	 * @param itemKey 字典标识
	 * @return 如果itemKey在层级的最后一级返回true，否则返回false
	 */
	public boolean isLastLayer(String itemKey){
		if(this.size() > 0){
			int index = this.size() -1;
			MetaLayer layer = this.get(index);
			return layer.getItemKey().equalsIgnoreCase(itemKey);
		}
		return false;
	}
	
	/**
	 * 根据itemKey 获取下一层的metaLayer
	 * @param itemKey 字典标识
	 * @return 取得itemKey字典所在层次的下一级，如果存在则返回，否则返回null
	 */
	public MetaLayer getNextMetaLayer(String itemKey){
		int index = 0;
		MetaLayer layer = null;
		for(int i = 0 ; i < this.size() ; i ++){
			layer = this.get(i);
			if(layer.getItemKey().equalsIgnoreCase(itemKey)){
				index = i ; 
				break;
			}
		}
		
		if(this.size() > (index + 1)){
			return this.get(index + 1);
		}
		return null;
	}
	
	public MetaLayer getPreviousMetaLayer(String itemKey){
		int index = 0;
		MetaLayer layer = null;
		for(int i = 0 ; i < this.size() ; i ++){
			layer = this.get(i);
			if(layer.getItemKey().equalsIgnoreCase(itemKey)){
				index = i ; 
				break;
			}
		}
		
		if((index - 1) >= 0){
			return this.get(index - 1);
		}
		return null;
	}
	
	/**
	 * 取得itemKey指定字典所在的层次的次序
	 * @param itemKey 字典标识
	 * @return 如果存在itemKey指定的层次则返回其次序，否则返回-1
	 */
	public int indexOf(String itemKey) {
		MetaLayer layer = null;
		for(int i = 0 ; i < this.size() ; i ++){
			layer = this.get(i);
			if(layer.getItemKey().equalsIgnoreCase(itemKey)){
				return i;
			}
		}
		return -1;
	}
	
	/** 表的标签名 */
	public static final String TAG_NAME = "Relation";

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (MetaLayer.TAG_NAME.equals(tagName)) {
			resultMetaObject = new MetaLayer();
			resultMetaObject.preProcessMetaObject(env, doc, node, flag, runType);
			add((MetaLayer) resultMetaObject);
		} 

		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaRelation();
	}

	@Override
	public AbstractMetaObject clone() {
		MetaRelation newRelation = (MetaRelation) super.clone();
		newRelation.setCaption(caption);
		newRelation.setDescription(description);
		return newRelation;
	}


}
