package com.bokesoft.yigo.meta.dataobject;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * 字典查询语句，用于字典节点查看，匹配性能较慢的场景。如根据明细值过滤，原本的实现为子查询，现可定义 2个表join的数据源提高查询效率。
 */
public class MetaDictQueryStatement extends AbstractMetaObject {
	/** 内容 */
	private String content = "";

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		
	}

	public static final String TAG_NAME = "DictQueryStatement";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	/**
	 * 设置内容
	 * @param content 内容
	 */
	public void setContent(String content) {
		this.content = content;
	}
	
	/**
	 * 取得内容
	 * @return 内容
	 */
	public String getContent() {
		return this.content;
	}
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaDictQueryStatement clone = new MetaDictQueryStatement();
		clone.setContent(content);
		return clone;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaDictQueryStatement();
	}
}
