package com.bokesoft.yigo.meta.dataobject;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaBatchPersist extends GenericKeyCollection<MetaTableSplit> {
	/** 批量持久化的类型 */
	private String type = "";
	/** 目标数据对象标识 */
	private String targetObjectKey = "";
	/** 主表 */
	private String primaryTable = "";
	
	public MetaBatchPersist() {
		super();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	public static final String TAG_NAME = "BatchPersist";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	/**
	 * 设置批量持久化的类型
	 * @param type 批量持久化的类型
	 */
	public void setType(String type) {
		this.type = type;
	}
	
	/**
	 * 取得批量持久化的类型
	 * @return 批量持久化的类型
	 */
	public String getType() {
		return this.type;
	}
	
	/**
	 * 设置目标数据对象标识
	 * @param targetObjectKey 目标数据对象标识
	 */
	public void setTargetObjectKey(String targetObjectKey) {
		this.targetObjectKey = targetObjectKey;
	}
	
	/**
	 * 取得目标数据对象标识
	 * @return 目标数据对象标识
	 */
	public String getTargetObjectKey() {
		return this.targetObjectKey;
	}
	
	/**
	 * 设置主表标识
	 * @param primaryTable 主表标识
	 */
	public void setPrimaryTable(String primaryTable) {
		this.primaryTable = primaryTable;
	}
	
	/**
	 * 取得主表标识
	 * @return 主表标识
	 */
	public String getPrimaryTable() {
		return this.primaryTable;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType)
			throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaTableSplit.TAG_NAME.equals(tagName) ) {
			MetaTableSplit tableSplit = new MetaTableSplit();
			tableSplit.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(tableSplit);
			resultMetaObject = tableSplit;
		}
		return resultMetaObject;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaBatchPersist newObject = (MetaBatchPersist)super.clone();
		newObject.setType(type);
		newObject.setTargetObjectKey(targetObjectKey);
		newObject.setPrimaryTable(primaryTable);
		
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaBatchPersist();
	}
	
}
