package com.bokesoft.yigo.meta.datamap.split;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaSplit extends GenericNoKeyCollection<AbstractMetaObject> {
	/** 拆分类型 */
	private Integer type = -1;
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	public static final String TAG_NAME = "Split";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	/**
	 * 设置拆分类型
	 * @param type 拆分类型
	 */
	public void setType(Integer type) {
		this.type = type;
	}
	
	/**
	 * 取得拆分类型
	 * @return 拆分类型
	 */
	public Integer getType() {
		return this.type;
	}
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaSplitGroup.TAG_NAME.equals(tagName) ) {
			resultMetaObject = new MetaSplitGroup();
			this.add(resultMetaObject);
		} else if ( MetaSplitProcess.TAG_NAME.equals(tagName) ) {
			resultMetaObject = new MetaSplitProcess();
			this.add(resultMetaObject);
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		// TODO Auto-generated method stub
		MetaSplit newObject = new MetaSplit();
		newObject.setType(type);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		// TODO Auto-generated method stub
		return new MetaSplit();
	}

}
