package com.bokesoft.yigo.meta.datamap;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.intf.IMetaProject;

/**
 * MetaDataMapProfile定义数据映射的属性信息，从数据映射文件中读取。
 * @author 王元和
 *
 */
public class MetaDataMapProfile extends KeyPairMetaObject {
	/** 映射的标识 */
	private String key = "";
	/** 映射的名称 */
	private String caption = "";
	/** 映射的描述 */
	private String description = "";
	/** 源数据对象标识 */
	private String srcDataObjectKey = "";
	/** 目标数据对象标识 */
	private String tgtDataObjectKey = "";
	/** 资源位置 */
	private String resource = null;
	/** 所在工程 */
	private IMetaProject project = null;
	/** 数据映射元数据 */
	private MetaMap dataMap = null;
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public String getTagName() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject newInstance() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getKey() {
		return this.key;
	}

	/**
	 * 设置标识
	 * @param key 标识
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * 设置名称
	 * @param caption 名称
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}
	
	/**
	 * 取得名称
	 * @return 名称
	 */
	public String getCaption() {
		return this.caption;
	}
	
	/**
	 * 设置描述
	 * @param description 描述
	 */
	public void setDescription(String description) {
		this.description = description;
	}
	
	/**
	 * 取得描述
	 * @return 描述
	 */
	public String getDescription() {
		return this.description;
	}
	
	/**
	 * 设置源数据对象标识
	 * @param srcDataObjectKey 源数据对象标识
	 */
	public void setSrcDataObjectKey(String srcDataObjectKey) {
		this.srcDataObjectKey = srcDataObjectKey;
	}
	
	/**
	 * 取得源数据对象标识
	 * @return 源数据对象标识
	 */
	public String getSrcDataObjectKey() {
		return this.srcDataObjectKey;
	}
	
	/**
	 * 设置目标数据对象标识
	 * @param tgtDataObjectKey 目标数据对象标识
	 */
	public void setTgtDataObjectKey(String tgtDataObjectKey) {
		this.tgtDataObjectKey = tgtDataObjectKey;
	}
	
	/**
	 * 取得目标数据对象标识
	 * @return 目标数据对象标识
	 */
	public String getTgtDataObjectKey() {
		return this.tgtDataObjectKey;
	}
	
	/**
	 * 设置资源路径
	 * @param resource 资源路径
	 */
	public void setResource(String resource) {
		this.resource = resource;
	}
	
	/**
	 * 取得资源路径
	 * @return 资源路径
	 */
	public String getResource() {
		return this.resource;
	}
	
	/**
	 * 设置工程引用
	 * @param project 工程引用
	 */
	public void setProject(IMetaProject project) {
		this.project = project;
	}
	
	/**
	 * 取得工程引用
	 * @return 工程引用
	 */
	public IMetaProject getProject() {
		return this.project;
	}
	
	/**
	 * 设置数据映射元数据
	 * @param dataMap 数据映射元数据
	 */
	public void setDataMap(MetaMap dataMap) {
		this.dataMap = dataMap;
	}
	
	/**
	 * 取得数据映射元数据
	 * @return 数据映射元数据
	 */
	public MetaMap getDataMap() {
		return this.dataMap;
	}
}
