package com.bokesoft.yigo.meta.dataelement;

import java.util.LinkedList;
import java.util.Set;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaDataElementCollection extends GenericKeyCollection<MetaDataElement> {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	/** 配置文件中对应片段的起始标签名称 */
	public static final String TAG_NAME = "DataElementCollection";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		
		if ( tagName.equals(MetaDataElement.TAG_NAME) ) {
			MetaDataElement meta = new MetaDataElement();
			meta.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(meta);
			resultMetaObject = meta;
		}
		
		return resultMetaObject;
	}

	public MetaDataElement add(MetaDataElement element) {
		check(element);
		return super.add(element);	
	}
	
	private void check(MetaDataElement element) {
		Set<String> keySet = elementMap.keySet();
		for(String s: keySet) {
			if(s.equalsIgnoreCase(element.getKey())) {
				throw new MetaException(MetaException.REPEAT_KEY_DEFINED,  SimpleStringFormat
						.format(StringTable.getString(null, "", StringTable.RepeatKeyDefined), element.getKey()));
			}
		}
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {

	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaDataElementCollection();
	}

}
