package com.bokesoft.yigo.meta.commondef;

import java.util.LinkedList;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyPairCompositeCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.IPropertyMerger;

/**
 * 窗口操作集合配置对象
 * 
 * @author chenzs
 * @since YES1.0
 */
public class MetaOperationCollection extends
	GenericKeyPairCompositeCollection implements IPropertyMerger<MetaOperationCollection> {
	/** 操作对象的标识 */
	private String key = "";

	/** 操作对象的说明 */
	private String caption = "";

	/** 操作对象的英文说明 */
	private String captionEn = "";

	/** 操作的具体内容 */
	private MetaBaseScript action = null;

	/** 操作是否可用 */
	private String enable = "";
	
	/** 可用依赖的字段*/
	private String enableDependency = "";

	/** 操作是否可用 */
	private String visible = "";
	
	/** 可见性依赖的字段*/
	private String visibleDependency = "";
	
	/** 图标 */
	private String icon = "";
	
	/** 自身事件是否禁用 */
	private Boolean selfDisable = false;
	
	/** 自定义样式*/
	private String cssClass = "";
	
	private String iconCode = "";
	
	/** 显示模式 */
	private Integer displayMode;
	
	public MetaOperationCollection() {
		super();
	}

	/** 配置文件中对应片段的起始标签名称 */
	public static final String TAG_NAME = "OperationCollection";

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new AbstractMetaObject[]{ action });
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node,
			String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		
		if ( tagName.equals(MetaOperation.TAG_NAME) ) {
			MetaOperation metaOperation = new MetaOperation();
			metaOperation.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(metaOperation);
			resultMetaObject = metaOperation;
		} else if ( tagName.equals(MetaOperationCollection.TAG_NAME) ) {
			MetaOperationCollection metaOperationCollection = new MetaOperationCollection();
			metaOperationCollection.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(metaOperationCollection);
			resultMetaObject = metaOperationCollection;
		} else if ( tagName.equalsIgnoreCase(MetaConstants.Event_Action) ) {
			action = new MetaBaseScript(MetaConstants.Event_Action);
			resultMetaObject = action;
		}
		else {
			throw new MetaException(MetaException.NO_ACTION_DEFINED,
					"No MetaObject defined for " + tagName);
		}
		
		return resultMetaObject;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaOperationCollection newObject = (MetaOperationCollection)super.clone();
		newObject.setKey(key);
		newObject.setCaption(caption);
		newObject.setCaptionEn(captionEn);
		newObject.setEnable(enable);
		newObject.setVisible(visible);
		newObject.setIcon(icon);
		newObject.setSelfDisable(selfDisable);
		newObject.setAction(action == null ? null : (MetaBaseScript)action.clone());
		newObject.setIconCode(iconCode);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaOperationCollection();
	}

	@Override
	public int getObjectType() {
		return MetaOperation.OperationCollection;
	}

	/**
	 * 获取操作对象的标识
	 */
	@Override
	public String getKey() {
		return key;
	}

	/**
	 * 设置操作对象的标识
	 * 
	 * @param key
	 *            标识
	 */
	public void setKey(String key) {
		this.key = key;
	}

	/**
	 * 获取样式
	 * @return
	 */
	public String getCssClass() {
		return cssClass;
	}

	/**
	 * 设置样式
	 * @param cssClass
	 */
	public void setCssClass(String cssClass) {
		this.cssClass = cssClass;
	}

	/**
	 * 获取操作对象的说明
	 * 
	 * @return 说明
	 */
	public String getCaption() {
		return caption;
	}

	/**
	 * 设置操作对象的说明
	 * 
	 * @param caption
	 *            说明
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}

	/**
	 * 获取操作对象的英文说明
	 *
	 * @return 英文说明
	 */
	public String getCaptionEn() {
		return captionEn;
	}

	/**
	 * 设置操作对象的英文说明
	 *
	 * @param captionEn
	 *            英文说明
	 */
	public void setCaptionEn(String captionEn) {
		this.captionEn = captionEn;
	}

	/**
	 * 设置操作对象的操作内容
	 * 
	 * @param action 操作内容
	 * @see MetaBaseScript
	 */
	public void setAction(MetaBaseScript action) {
		this.action = action;
	}

	/**
	 * 获取操作对象的操作内容
	 * 
	 * @return 操作内容
	 * @see MetaBaseScript
	 */
	public MetaBaseScript getAction() {
		return action;
	}

	/**
	 * 设置操作是否可用
	 * 
	 * @param enable
	 *            是否可用
	 */
	public void setEnable(String enable) {
		this.enable = enable;
	}

	/**
	 * 获取操作是否可用
	 * 
	 * @return 是否可用
	 */
	public String getEnable() {
		return this.enable;
	}

	/**
	 * 设置操作是否可见
	 * 
	 * @param visible
	 *            是否可见
	 */
	public void setVisible(String visible) {
		this.visible = visible;
	}

	/**
	 * 获取操作是否可见
	 * 
	 * @return 是否可见
	 */
	public String getVisible() {
		return this.visible;
	}
	
	/**
	 * 设置图标路径
	 * @param icon 图标路径
	 */
	public void setIcon(String icon) {
		this.icon = icon;
	}
	
	/**
	 * 取得图标路径
	 * @return 图标路径
	 */
	public String getIcon() {
		return this.icon;
	}
	
	/**
	 * 设置自身事件是否禁用
	 * @param selfDisable boolean，禁用标志
	 */
	public void setSelfDisable(Boolean selfDisable) {
		this.selfDisable = selfDisable;
	}
	
	/**
	 * 取得自身事件是否禁用
	 * @return boolean，禁用标志
	 */
	public Boolean isSelfDisable() {
		return this.selfDisable;
	}

	/**
	 * 获取可用性的依赖字段,","隔开
	 * @return 可用性依赖字段定义
	 */
	public String getEnableDependency() {
		return enableDependency;
	}

	/**
	 * 设置可用性依赖的字段
	 * @param enableDependency 可用性依赖字段定义
	 */
	public void setEnableDependency(String enableDependency) {
		this.enableDependency = enableDependency;
	}

	/**
	 * 获取可见性依赖的字段,","隔开
	 * @return 可见性依赖字段定义
	 */
	public String getVisibleDependency() {
		return visibleDependency;
	}

	/**
	 * 设置可见性依赖的字段
	 * @param visibleDependency 可用性依赖字段定义
	 */
	public void setVisibleDependency(String visibleDependency) {
		this.visibleDependency = visibleDependency;
	}
	
	public String getIconCode() {
		return iconCode;
	}

	public void setIconCode(String iconCode) {
		this.iconCode = iconCode;
	}
	
	public Integer getDisplayMode() {
		return displayMode;
	}

	public void setDisplayMode(Integer displayMode) {
		this.displayMode = displayMode;
	}

	
	@Override
	public boolean needCheckExtend() {
		return true;
	}

	@Override
	public void merge(MetaOperationCollection metaOpts) {
		this.getChild().forEach((key, metaOperation) -> {
			if (metaOperation instanceof MetaOperation ){
				if (metaOpts.get(key) == null) {
					MetaOperation operation = (MetaOperation) metaOperation.clone();
					operation.setManaged(false);
					operation.setExpand(false);
					operation.setNeedAccessLog(false);
					this.add(metaOperation);
				} else {
					((MetaOperation)metaOpts.get(key) ).merge((MetaOperation)metaOperation );
				}
			}else {
				if (metaOpts.get(key) == null) {
					MetaOperationCollection operation = (MetaOperationCollection) metaOperation.clone();
					this.add(operation);
				} else {
					((MetaOperationCollection) metaOpts.get(key)).merge((MetaOperationCollection) metaOperation);
				}
			}

		});
		if( this.caption == null ) {
			this.caption = metaOpts.getCaption();
		}
		if( this.captionEn == null ) {
			this.captionEn = metaOpts.getCaptionEn();
		}
		MetaBaseScript action = metaOpts.getAction();
		if( action != null ) {
			if( this.action == null ) {
				this.action = (MetaBaseScript) action.clone();				
			}
		}
		if( this.enable == null ) {
			this.enable = metaOpts.getEnable();
		}
		if( this.visible == null ) {
			this.visible = metaOpts.getVisible();
		}
		if( this.enableDependency == null ) {
			this.enableDependency = metaOpts.getEnableDependency();
		}
		if( this.visibleDependency == null ) {
			this.visibleDependency = metaOpts.getVisibleDependency();
		}
		if( this.icon == null ) {
			this.icon = metaOpts.getIcon();
		}
		if( this.selfDisable == null ) {
			this.selfDisable = metaOpts.isSelfDisable();
		}
		if( this.cssClass == null ) {
			this.cssClass = metaOpts.getCssClass();
		}
		if (this.iconCode == null) {
			this.iconCode = metaOpts.getIconCode();
		}
		if (this.displayMode == null) {
			this.displayMode = metaOpts.getDisplayMode();
		}
	}
}
