package com.bokesoft.yigo.meta.common;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollectionWithKey;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MetaProcessFlow定义中间层服务扩展处理流，由多个处理步骤{@link MetaMidProcess}组成
 * @author 王元和
 *
 */
public class MetaMidProcessFlow extends GenericNoKeyCollectionWithKey<MetaMidProcess> {
	/** 服务名，以ServiceName:Cmd表示，Cmd为空的时候，不要加: */
	private String service = "";
	public MetaMidProcessFlow() {
		super();
	}
	
	@Override
	public String getKey() {
		return service;
	}
	
	/**
	 * 设置服务名
	 * @param service 服务名
	 */
	public void setService(String service) {
		this.service = service;
	}
	
	/**
	 * 取得服务名
	 * @return 服务名
	 */
	public String getService() {
		return this.service;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	public static final String TAG_NAME = "MidProcessFlow";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaMidProcess.TAG_NAME.equals(tagName) ) {
			MetaMidProcess metaProcess = new MetaMidProcess();
			resultMetaObject = this.add(metaProcess);
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaMidProcessFlow();
	}

	@Override
	public boolean needPreLoad() {
		return true;
	}
}
