package com.bokesoft.yigo.meta.common;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MetaCustomCondition定义定制的查询条件相关的配置，包括使用条件和语句以及语句中用到的参数集合。
 * @author wangyh
 *
 */
public class MetaCustomCondition extends GenericNoKeyCollection<MetaCustomConditionPara> {
	/** 条件 */
	private String condition = "";
	/** 过滤 */
	private String filter = "";
	/**是否是多个参数*/
	private Boolean multiPara = false;
	/**参数分隔符，默认为“,”*/
	private String seperator = ",";
	
	public MetaCustomCondition() {
		super();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	public static final String TAG_NAME = "CustomCondition";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaCustomConditionPara.TAG_NAME.equals(tagName) ) {
			MetaCustomConditionPara para = new MetaCustomConditionPara();
			this.add(para);
			resultMetaObject = para;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaCustomCondition();
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaCustomCondition newObject = (MetaCustomCondition)super.clone();
		newObject.setCondition(condition);
		newObject.setFilter(filter);
		newObject.setSeperator(seperator);
		newObject.setMultiPara(multiPara);
		return newObject;
	}

	/**
	 * 设置条件
	 * @param condition 条件
	 */
	public void setCondition(String condition) {
		this.condition = condition;
	}
	
	/**
	 * 取得条件
	 * @return 条件
	 */
	public String getCondition() {
		return this.condition;
	}
	
	/**
	 * 设置过滤
	 * @param filter 过滤
	 */
	public void setFilter(String filter) {
		this.filter = filter;
	}
	
	/**
	 * 取得过滤
	 * @return 过滤
	 */
	public String getFilter() {
		return this.filter;
	}
	public String getSeperator() {
		return seperator;}
	public void setSeperator(String seperator) {
		this.seperator = seperator;
	}
	public Boolean getMultiPara() {
		return multiPara;
	}

	public void setMultiPara(Boolean multiPara) {
		this.multiPara = multiPara;
	}

}
