package com.bokesoft.yigo.meta.charging;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MetaChargingObject定义计费对象，计费对象引用数据对象定义数据的来源
 * @author wangyh
 *
 */
public class MetaChargingObject extends AbstractMetaObject {
	/** 标识 */
	private String key = "";
	/** 名称 */
	private String caption = "";
	/** 描述 */
	private String description = "";
	/** 数据对象标识 */
	private String objectKey = "";
	/** 表标识 */
	private String tableKey = "";
	
	public MetaChargingObject() {
		super();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	public static final String TAG_NAME = "ChargingObject";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	/**
	 * 设置标识
	 * @param key 标识
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * 取得标识
	 * @return 标识
	 */
	public String getKey() {
		return this.key;
	}
	
	/**
	 * 设置名称
	 * @param caption 名称
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}
	
	/**
	 * 取得名称
	 * @return 名称
	 */
	public String getCaption() {
		return this.caption;
	}
	
	/**
	 * 设置描述
	 * @param description 描述
	 */
	public void setDescription(String description) {
		this.description = description;
	}
	
	/**
	 * 取得描述
	 * @return 描述
	 */
	public String getDescription() {
		return this.description;
	}
	
	/**
	 * 设置数据对象标识
	 * @param objectKey 数据对象标识
	 */
	public void setObjectKey(String objectKey) {
		this.objectKey = objectKey;
	}
	
	/**
	 * 取得数据对象标识
	 * @return 数据对象标识
	 */
	public String getObjectKey() {
		return this.objectKey;
	}
	
	/**
	 * 设置表标识
	 * @param tableKey 表标识
	 */
	public void setTableKey(String tableKey) {
		this.tableKey = tableKey;
	}
	
	/**
	 * 取得表标识
	 * @return 表标识
	 */
	public String getTableKey() {
		return this.tableKey;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaChargingObject newObject = (MetaChargingObject)newInstance();
		newObject.setKey(key);
		newObject.setCaption(caption);
		newObject.setDescription(description);
		newObject.setObjectKey(objectKey);
		newObject.setTableKey(tableKey);
		
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaChargingObject();
	}

}
