package com.bokesoft.yigo.meta.bpm.process.transition;

import org.json.JSONObject;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;

public class MetaSequenceFlow extends MetaTransition {

	public final static String TAG_NAME = "SequenceFlow";

	private String trigger = "";

	private String state = "";

	private String condition = "true";

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaSequenceFlow();
	}

	@Override
	public AbstractMetaObject clone() {
		MetaSequenceFlow newSequenceFlow = (MetaSequenceFlow) super.clone();
		newSequenceFlow.setTrigger(trigger);
		newSequenceFlow.setState(state);
		newSequenceFlow.setCondition(condition);
		return newSequenceFlow;
	}

	public String getTrigger() {
		return trigger;
	}

	public void setTrigger(String trigger) {
		this.trigger = trigger;
	}

	public String getState() {
		return state;
	}

	public void setState(String state) {
		this.state = state;
	}

	public String getCondition() {
		return condition;
	}

	public void setCondition(String condition) {
		this.condition = condition;
	}

	@Override
	public JSONObject toJSON() {
		JSONObject obj = super.toJSON();
		obj.put("trigger", trigger);
		obj.put("state", state);
		obj.put("condition", condition);
		
		return obj;
	}

	@Override
	public void fromJSON(JSONObject json) {
		super.fromJSON(json);
		this.trigger = json.optString("trigger");
		this.state = json.optString("state");
//		json.put("trigger", trigger);
//		json.put("state", state);
//		json.put("condition", condition);
	}

}
