package com.bokesoft.yigo.meta.bpm.process.node;

import java.util.LinkedList;

import org.json.JSONObject;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaConditonExternalLink;

public class MetaDecision extends MetaNode {

	public final static String TAG_NAME = "Decision";

	private String condition = "";
	
	private MetaConditonExternalLink conditionExternalLink = new MetaConditonExternalLink();
	
	public MetaConditonExternalLink getConditonExternalLink() {
		return conditionExternalLink;
	}
	
	public void setConditonExternalLink(MetaConditonExternalLink conditionExternalLink) {
		this.conditionExternalLink = conditionExternalLink;
	}

	public String getCondition() {
		return condition;
	}

	public void setCondition(String condition) {
		this.condition = condition;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getNodeType() {
		return NodeType.DECISION;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		super.getChildMetaObjects(list);
		list.add(conditionExternalLink);
	}
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject child = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
		if (child != null) {
			return child;
		}
		if (tagName.equalsIgnoreCase(MetaConditonExternalLink.TAG_NAME)) {
			conditionExternalLink = new MetaConditonExternalLink();
			child = conditionExternalLink;
			child.preProcessMetaObject(env, doc, node, flag, runType);
		}
		
		return child;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaDecision newDecision = (MetaDecision) super.clone();
		newDecision.setCondition(condition);
		return newDecision;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaDecision();
	}

	@Override
	public JSONObject toJSON() {
		JSONObject obj = super.toJSON();
		obj.put("condition", condition);
		return obj;
	}

	@Override
	public void fromJSON(JSONObject json) {
		super.fromJSON(json);
		this.condition = json.optString("condition");
	}
}
