package com.bokesoft.yigo.meta.bpm.process.node;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.common.MetaBaseScript;

public class MetaComplexJoin extends MetaJoin {

	public final static String TAG_NAME = "ComplexJoin";

	/** 操作的事件 */
	private MetaBaseScript joinCondition = null;

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getNodeType() {
		return NodeType.COMPLEX_JOIN;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaComplexJoin();
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
		if (resultMetaObject != null)
			return resultMetaObject;
		if (BPMConstants.NODE_JOIN_CONDITION.equals(tagName)) {
			this.joinCondition = new MetaBaseScript(BPMConstants.NODE_JOIN_CONDITION);
			resultMetaObject = this.joinCondition;
		}
		return resultMetaObject;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		super.getChildMetaObjects(list);
		if (joinCondition != null) {
			list.add(joinCondition);
		}
	}

	public MetaBaseScript getJoinCondition() {
		return joinCondition;
	}

	public void setJoinCondition(MetaBaseScript joinCondition) {
		this.joinCondition = joinCondition;
	}

}
