package com.bokesoft.yigo.meta.bpm.process.node;

import org.json.JSONObject;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;

public class MetaAnchor extends MetaNode {

	public final static String TAG_NAME = "Anchor";
	
	/** 跳转到主流程的节点ID */
	private Integer straightNodeID = -1;
	/** 跳转到内联流程的节点ID */
	private Integer straightEmbedNodeID = -1;
	
	@Override
	public int getNodeType() {
		return NodeType.ANCHOR;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaAnchor();
	}
	
	public Integer getStraightNodeID(){
		return straightNodeID;
	}
	
	public void setStraightNodeID(Integer straightNodeID){
		this.straightNodeID = straightNodeID;
	}
	
	public Integer getStraightEmbedNodeID(){
		return straightEmbedNodeID;
	}
	
	public void setStraightEmbedNodeID(Integer straightEmbedNodeID){
		this.straightEmbedNodeID = straightEmbedNodeID;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaAnchor metaAnchor = (MetaAnchor)super.clone();
		metaAnchor.setStraightNodeID(straightNodeID);
		metaAnchor.setStraightEmbedNodeID(straightEmbedNodeID);
		return metaAnchor;
	}
	
	@Override
	public JSONObject toJSON() {
		JSONObject obj = super.toJSON();
		obj.put("straightNodeID", straightNodeID);
		obj.put("straightEmbedNodeID", straightEmbedNodeID);
		return obj;
	}
	
	@Override
	public void fromJSON(JSONObject json) {
		super.fromJSON(json);
		this.straightNodeID = json.optInt("straightNodeID");
		this.straightEmbedNodeID = json.optInt("straightEmbedNodeID");
	}

}
