package com.bokesoft.yigo.meta.bpm.process.message;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaConsumer extends AbstractMetaObject {

	public static final String TAG_NAME = "Consumer";
	
	/** 是否接收消息*/
	private Boolean isReceiveMessage = false;
	/** 自定义消息处理*/
	private String receiveHandleImpl = "";
	
	public void setReceiveHandleImpl(String receiveHandleImpl) {
		this.receiveHandleImpl = receiveHandleImpl;
	}
	
	public String getReceiveHandleImpl() {
		return receiveHandleImpl;
	}
	
	/**
	 * 设置是否接收消息
	 * @param isReceiveMessage 是否接收消息
	 */
	public void setIsReceiveMessage(Boolean isReceiveMessage) {
		this.isReceiveMessage = isReceiveMessage;
	}
	
	/**
	 * 取得是否接收消息
	 * @return 是否接收消息
	 */
	public Boolean isReceiveMessage() {
		return isReceiveMessage;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaConsumer obj = (MetaConsumer)newInstance();
		obj.isReceiveMessage = isReceiveMessage;
		obj.receiveHandleImpl = receiveHandleImpl;
		return obj;
	}
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	@Override
	public AbstractMetaObject newInstance() {
		return new MetaConsumer();
	}
}
